/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.BaseShape;
import cgdp.recog.ptree.bean.ColorButton;
import cgdp.recog.ptree.bean.CommonProcess;
import cgdp.recog.ptree.bean.DndData;
import cgdp.recog.ptree.bean.OptionDialog;
import cgdp.recog.ptree.bean.PageSetupItem;
import cgdp.recog.ptree.bean.PdfItem;
import cgdp.recog.ptree.bean.PdfTool;
import cgdp.recog.ptree.bean.PtreeMainWindow;
import cgdp.recog.ptree.bean.RedrawItem;
import cgdp.recog.ptree.bean.RedrawTool;
import cgdp.recog.ptree.bean.RootedHItem;
import cgdp.recog.ptree.bean.RootedHTool;
import cgdp.recog.ptree.bean.ShowLengthOnOffItem;
import cgdp.recog.ptree.bean.ShowLengthOnOffTool;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.TreeArea;
import cgdp.recog.ptree.bean.UnrootedItem;
import cgdp.recog.ptree.bean.UnrootedTool;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.VersionWindow;
import cgdp.recog.ptree.bean.data.OptionTbl;
import cgdp.recog.ptree.bean.data.OptionValues;
import cgdp.recog.ptree.bean.filter.PdfFilter;
import cgdp.recog.ptree.bean.interfaces.MediatorImpl;
import cgdp.recog.ptree.bean.interfaces.RecogQueryImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

public class Mediator
implements MediatorImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(Mediator.class);
    OptionTbl m_optionTbl;
    OptionDialog m_optionDialog;
    RootedHItem m_rootedHItem;
    RootedHTool m_rootedHTool;
    UnrootedItem m_unrootedItem;
    UnrootedTool m_unrootedTool;
    ShowLengthOnOffItem m_showLenOnOffItem;
    ShowLengthOnOffTool m_showLenOnOffTool;
    PageSetupItem m_pageSetupItem;
    PageFormat m_pageFormat;
    PdfItem m_pdfItem;
    PdfTool m_pdfTool;
    RedrawItem m_redrawItem;
    RedrawTool m_redrawTool;
    PtreeMainWindow m_mainWindow;
    VersionWindow m_versionWindow;
    TreeArea m_treeArea;
    ArrayList m_procList;
    boolean m_isWindows;
    int m_exitAction;
    Cursor m_defaultCursor;
    Cursor m_waitCursor;

    public Mediator(OptionTbl optionTbl) {
        this.clear();
        this.setOptionTbl(optionTbl);
    }

    public static MediatorImpl createInstance(String string, RecogQueryImpl recogQueryImpl) {
        Object object;
        OptionTbl optionTbl = !Utils.isNull(string) ? new OptionTbl(string + File.separator + "ptree.dat") : new OptionTbl();
        if (recogQueryImpl != null) {
            object = optionTbl.getOptionValues();
            ((OptionValues)object).setInGroupColor(recogQueryImpl.getInGroupColor());
            ((OptionValues)object).setOutGroupColor(recogQueryImpl.getOutGroupColor());
        }
        object = new Mediator(optionTbl);
        return object;
    }

    private void clear() {
        this.m_optionDialog = null;
        this.m_rootedHItem = null;
        this.m_rootedHTool = null;
        this.m_unrootedItem = null;
        this.m_unrootedTool = null;
        this.m_showLenOnOffItem = null;
        this.m_showLenOnOffTool = null;
        this.m_pageSetupItem = null;
        this.m_pageFormat = PrinterJob.getPrinterJob().defaultPage();
        this.m_pdfItem = null;
        this.m_pdfTool = null;
        this.m_redrawItem = null;
        this.m_redrawTool = null;
        this.m_mainWindow = null;
        this.m_versionWindow = null;
        this.m_treeArea = null;
        this.m_procList = new ArrayList();
        this.m_isWindows = System.getProperty("os.name").startsWith("Windows");
        this.m_exitAction = 0;
        this.m_defaultCursor = new Cursor(0);
        this.m_waitCursor = new Cursor(3);
    }

    private void setPdfButtonEnabled(boolean bl) {
        this.m_pdfItem.setEnabled(bl);
        this.m_pdfTool.setEnabled(bl);
    }

    private void setRedrawButtonEnabled(boolean bl) {
        this.m_redrawItem.setEnabled(bl);
        this.m_redrawTool.setEnabled(bl);
    }

    private void updateButtonEnabled() {
        Tree tree = this.m_treeArea.getTree();
        boolean bl = tree != null && tree.size() > 0;
        this.setPdfButtonEnabled(bl);
        this.setRedrawButtonEnabled(bl);
    }

    public static boolean confirmOverwrite(Component component, String string) {
        return Mediator.confirmMessage(component, "Overwrite " + string + "?");
    }

    public static boolean confirmMessage(Component component, String string) {
        int n = JOptionPane.showConfirmDialog(component, string, "Confirm", 0, 3);
        return n == 0;
    }

    private void closeWindows() {
        this.closeOptionDialog();
    }

    public void setOptionTbl(OptionTbl optionTbl) {
        this.m_optionTbl = optionTbl;
    }

    public OptionTbl getOptionTbl() {
        return this.m_optionTbl;
    }

    public void setupDialog(int n) {
        this.m_optionDialog = new OptionDialog(this.m_mainWindow, this.m_treeArea, this, n, this.m_mainWindow.getQueryImpl());
    }

    public void closeOptionDialog() {
        if (this.m_optionDialog != null) {
            this.m_optionDialog.dispose();
            this.m_optionDialog = null;
        }
    }

    public void saveOption() {
        try {
            this.m_mainWindow.setCursor(this.m_waitCursor);
            this.m_optionDialog.writeOption();
            this.m_optionDialog.dispose();
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
        catch (Exception exception) {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
            JOptionPane.showMessageDialog(this.m_optionDialog, exception.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
            JOptionPane.showMessageDialog(this.m_optionDialog, "Out of memory error occured.", "Error", 0);
        }
    }

    public void openDnd() {
        String string = this.m_optionTbl.getOptionValues().isExistDndOpenDir() ? this.m_optionTbl.getOptionValues().getDndOpenDir() : System.getProperty("user.dir");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(string));
        jFileChooser.setDialogTitle("Read DND File");
        if (jFileChooser.showOpenDialog(this.m_mainWindow) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!CommonProcess.isDND(file)) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Can't reading " + "'" + file.getName() + "'", "Error", 0);
            return;
        }
        this.m_optionTbl.getOptionValues().setDndOpenDir(file.getParent());
        this.readDnd(file.getAbsolutePath());
    }

    public Tree createTreeFromFile(String string) throws Exception {
        DndData dndData = new DndData();
        dndData.read(string);
        Tree tree = dndData.result();
        if (tree == null) {
            throw new IllegalArgumentException("Fail to read Tree File.");
        }
        JPanel jPanel = new JPanel();
        tree.setFontMetrics(jPanel.getFontMetrics(this.m_optionTbl.getFont()));
        File file = new File(string);
        if (file.isFile() && file.exists()) {
            tree.setName(file.getName());
        }
        return tree;
    }

    public void updateTreeArea(Tree tree) throws Exception {
        this.m_treeArea.setTree(tree);
        this.updateButtonEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDnd(String string) {
        try {
            this.m_mainWindow.setCursor(this.m_waitCursor);
            Tree tree = this.createTreeFromFile(string);
            this.m_treeArea.setTree(tree);
            this.updateButtonEnabled();
        }
        catch (Exception exception) {
            String string2 = "Fail to update tree view.";
            logger.warn(string2, exception);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string2);
        }
        catch (Error error) {
            String string3 = "Fail to update tree view.";
            logger.warn(string3, error);
            MessageManager.showErrorMessage((Component)this.m_mainWindow, string3);
        }
        finally {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
    }

    public void changeWindowSize() {
        try {
            this.m_treeArea.changeWindowSize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
            return;
        }
    }

    public void changeTreeStyle(int n) {
        if (n == this.m_optionTbl.getOptionValues().getTreeStyle()) {
            return;
        }
        boolean bl = n == 1;
        boolean bl2 = n == 2;
        this.m_rootedHItem.setState(bl);
        this.m_unrootedItem.setState(bl2);
        this.m_rootedHTool.setSelected(bl);
        this.m_unrootedTool.setSelected(bl2);
        this.m_optionTbl.getOptionValues().setTreeStyle(n);
        try {
            Tree tree = this.m_treeArea.getTree();
            if (tree != null && tree.size() > 0) {
                this.m_treeArea.changeTreeStyle(this.m_mainWindow.getScrollPane().getViewport().getExtentSize());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
            return;
        }
    }

    public void showLengthOnOff(Object object) {
        if (object instanceof ShowLengthOnOffItem) {
            this.m_showLenOnOffTool.setSelected(this.m_showLenOnOffItem.getState());
        } else {
            this.m_showLenOnOffItem.setState(this.m_showLenOnOffTool.isSelected());
        }
        this.m_optionTbl.getOptionValues().setShowLength(this.m_showLenOnOffItem.getState());
        try {
            Tree tree = this.m_treeArea.getTree();
            if (tree != null && tree.size() > 0) {
                this.m_treeArea.showLengthOnOff();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
            return;
        }
    }

    public void changeFontSize(int n) {
        try {
            this.m_optionTbl.getOptionValues().setFontType(n);
            this.m_optionTbl.createFont();
            Tree tree = this.m_treeArea.getTree();
            if (tree != null && tree.size() > 0) {
                this.m_treeArea.changeFont(this.m_optionTbl.getFont());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
            return;
        }
    }

    public void changeNodeSymbol(int n) {
        try {
            Tree tree = this.m_treeArea.getTree();
            if (tree != null && tree.size() > 0) {
                this.m_treeArea.changeNodeSymbol(n);
            }
            this.m_optionTbl.getOptionValues().setNodeSymbol(n);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
            return;
        }
    }

    public void changeColor(Object object) {
        if (object == null) {
            return;
        }
        try {
            BaseShape baseShape = (BaseShape)object;
            Color color = JColorChooser.showDialog(this.m_mainWindow, "Color palette", baseShape.getColor());
            if (color != null) {
                baseShape.setColor(color);
                Tree tree = this.m_treeArea.getTree();
                if (tree != null && tree.size() > 0) {
                    this.m_treeArea.colorChanged();
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
            return;
        }
    }

    public void pageSetup() {
        this.m_pageFormat = PrinterJob.getPrinterJob().pageDialog(this.m_pageFormat);
    }

    public void print() {
        try {
            if (!Mediator.confirmMessage(this.m_mainWindow, "Print?")) {
                return;
            }
            this.m_treeArea.print(this.m_pageFormat);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
        }
    }

    public void writePdf() {
        try {
            String string;
            String string2;
            String string3 = this.m_optionTbl.getOptionValues().getPdfSaveDir();
            if (!new File(string3).exists() || !new File(string3).isDirectory()) {
                string3 = System.getProperty("user.dir");
            }
            string = Utils.isNull(string2 = Utils.getSuffix(string = this.m_treeArea.getTree().getName())) ? string + ".pdf" : string.substring(0, string.length() - string2.length() - 1) + ".pdf";
            File file = new File(string3 + "/" + string);
            JFileChooser jFileChooser = new JFileChooser(string3);
            jFileChooser.setFileFilter(new PdfFilter());
            jFileChooser.setDialogTitle("Save PDF File");
            jFileChooser.setSelectedFile(file);
            if (jFileChooser.showSaveDialog(this.m_mainWindow) != 0) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            string2 = Utils.getSuffix(file.getName());
            if (Utils.isNull(string2) || !string2.equalsIgnoreCase("PDF")) {
                file = new File(file.getAbsolutePath() + ".pdf");
            }
            if (file.exists() && !Mediator.confirmOverwrite(this.m_mainWindow, file.getName())) {
                return;
            }
            this.m_mainWindow.setCursor(this.m_waitCursor);
            int n = this.m_optionTbl.getOptionValues().getNodeSymbol();
            this.m_treeArea.changeNodeVectorSymbol(0);
            this.m_treeArea.writePdf(file.getAbsolutePath(), this.m_pageFormat);
            this.m_treeArea.changeNodeVectorSymbol(n);
            this.m_optionTbl.getOptionValues().setPdfSaveDir(file.getParent());
            this.m_mainWindow.setCursor(this.m_defaultCursor);
        }
        catch (Exception exception) {
            this.m_mainWindow.setCursor(this.m_defaultCursor);
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
        }
        catch (Error error) {
            error.printStackTrace();
            this.m_mainWindow.setCursor(this.m_defaultCursor);
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
        }
    }

    public void redraw() {
        try {
            Tree tree = this.m_treeArea.getTree();
            if (tree != null && tree.size() > 0) {
                this.m_treeArea.changeTreeStyle(this.m_mainWindow.getScrollPane().getViewport().getExtentSize());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
            return;
        }
    }

    public String chooseFile(Object object, String string, String string2, Object object2) {
        String string3;
        if (Utils.isNull(string)) {
            string3 = !Utils.isNull(string2) && new File(string2).exists() && new File(string2).isDirectory() ? string2 : System.getProperty("user.dir");
        } else if (new File(string).exists() && new File(string).isFile()) {
            string3 = new File(string).getParent();
        } else {
            string3 = !Utils.isNull(string2) && new File(string2).exists() && new File(string2).isDirectory() ? string2 : System.getProperty("user.dir");
            string = null;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(string3));
        jFileChooser.setDialogTitle("Select file");
        if (!Utils.isNull(string)) {
            jFileChooser.setSelectedFile(new File(string));
        }
        if (object2 != null) {
            jFileChooser.setFileFilter((FileFilter)object2);
        }
        jFileChooser.setApproveButtonText("OK");
        if (jFileChooser.showOpenDialog((Component)object) == 0) {
            if (this.m_isWindows) {
                return jFileChooser.getSelectedFile().getAbsolutePath();
            }
            File file = jFileChooser.getSelectedFile();
            String string4 = file.getAbsolutePath();
            if (file.isDirectory() && string4.endsWith(".app")) {
                String string5 = file.getName().substring(0, file.getName().length() - 4);
                String string6 = file.getAbsolutePath() + File.separator + "Contents" + File.separator + "MacOS" + File.separator + string5;
                if (new File(string6).isFile()) {
                    return string6;
                }
                return string4;
            }
            return string4;
        }
        return null;
    }

    public String chooseDirectory(Object object, String string, String string2) {
        if (Utils.isNull(string)) {
            string = !Utils.isNull(string2) && new File(string2).exists() && new File(string2).isDirectory() ? string2 : System.getProperty("user.dir");
        } else if (!new File(string).exists() || !new File(string).isDirectory()) {
            string = !Utils.isNull(string2) && new File(string2).exists() && new File(string2).isDirectory() ? string2 : System.getProperty("user.dir");
        }
        JFileChooser jFileChooser = new JFileChooser();
        File file = new File(string);
        File file2 = null;
        if (file.getParent() != null) {
            file2 = new File(file.getParent());
        }
        if (file2 != null && file2.isDirectory()) {
            jFileChooser.setCurrentDirectory(file2);
        } else {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle("Select directory");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(string));
        if (jFileChooser.showDialog((Component)object, "OK") == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public void chooseColor(Object object) {
        Component component = (Component)object;
        Color color = JColorChooser.showDialog(component, "Color palette", component.getBackground());
        if (color != null) {
            component.setBackground(color);
        }
    }

    public void chooseInGroupColor(Object object) {
        try {
            Component component = (Component)object;
            Color color = JColorChooser.showDialog(component, "Color palette", component.getBackground());
            if (color != null) {
                component.setBackground(color);
                String string = ColorButton.color2Str(color);
                this.m_optionTbl.getOptionValues().setInGroupColor(string);
                this.m_treeArea.colorChanged();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
        }
    }

    public void chooseOutGroupColor(Object object) {
        try {
            Component component = (Component)object;
            Color color = JColorChooser.showDialog(component, "Color palette", component.getBackground());
            if (color != null) {
                component.setBackground(color);
                String string = ColorButton.color2Str(color);
                this.m_optionTbl.getOptionValues().setOutGroupColor(string);
                this.m_treeArea.colorChanged();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
        }
    }

    public void chooseSpeciesColor(Object object, String string) {
        try {
            Component component = (Component)object;
            Color color = JColorChooser.showDialog(component, "Color palette", component.getBackground());
            if (color != null) {
                component.setBackground(color);
                String string2 = ColorButton.color2Str(color);
                TreeMap treeMap = this.m_treeArea.getSpeciesColorMap();
                treeMap.put(string, string2);
                this.m_treeArea.colorChanged();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
        }
    }

    public void setExitAction(int n) {
        this.m_exitAction = n;
    }

    public void exit() {
        Rectangle rectangle = this.m_mainWindow.getBounds();
        OptionValues optionValues = this.m_optionTbl.getOptionValues();
        optionValues.setMainWindowX(rectangle.x);
        optionValues.setMainWindowY(rectangle.y);
        optionValues.setMainWindowW(rectangle.width);
        optionValues.setMainWindowH(rectangle.height);
        try {
            this.m_optionTbl.writeOption();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
        }
        Iterator iterator = this.m_procList.iterator();
        while (iterator.hasNext()) {
            ((Process)iterator.next()).destroy();
        }
        this.closeWindows();
        if (this.m_exitAction == 0) {
            System.exit(0);
        } else {
            this.m_mainWindow.dispose();
        }
    }

    public void updateView() {
        try {
            this.m_treeArea.colorChanged();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.m_mainWindow, exception.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this.m_mainWindow, "Out of memory error occured.", "Error", 0);
        }
    }

    public void versionWindow() {
        if (this.m_versionWindow != null) {
            this.closeVersionWindow();
        }
        this.m_versionWindow = new VersionWindow(this);
    }

    public void closeVersionWindow() {
        if (this.m_versionWindow != null) {
            this.m_versionWindow.dispose();
            this.m_versionWindow = null;
        }
    }

    public void allSelect(Object object) {
        if (object instanceof JTable) {
            JTable jTable = (JTable)object;
            int n = jTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                jTable.setValueAt(new Boolean(true), i, 0);
            }
        }
    }

    public void reverseSelect(Object object) {
        if (object instanceof JTable) {
            JTable jTable = (JTable)object;
            int n = jTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                boolean bl = (Boolean)jTable.getValueAt(i, 0);
                jTable.setValueAt(new Boolean(!bl), i, 0);
            }
        }
    }

    public void register(Object object) {
        if (object instanceof OptionDialog) {
            this.m_optionDialog = (OptionDialog)object;
        } else if (object instanceof RootedHItem) {
            this.m_rootedHItem = (RootedHItem)object;
        } else if (object instanceof RootedHTool) {
            this.m_rootedHTool = (RootedHTool)object;
        } else if (object instanceof UnrootedItem) {
            this.m_unrootedItem = (UnrootedItem)object;
        } else if (object instanceof UnrootedTool) {
            this.m_unrootedTool = (UnrootedTool)object;
        } else if (object instanceof ShowLengthOnOffItem) {
            this.m_showLenOnOffItem = (ShowLengthOnOffItem)object;
        } else if (object instanceof ShowLengthOnOffTool) {
            this.m_showLenOnOffTool = (ShowLengthOnOffTool)object;
        } else if (object instanceof PdfItem) {
            this.m_pdfItem = (PdfItem)object;
        } else if (object instanceof PdfTool) {
            this.m_pdfTool = (PdfTool)object;
        } else if (object instanceof RedrawItem) {
            this.m_redrawItem = (RedrawItem)object;
        } else if (object instanceof RedrawTool) {
            this.m_redrawTool = (RedrawTool)object;
        } else if (object instanceof PtreeMainWindow) {
            this.m_mainWindow = (PtreeMainWindow)object;
        } else if (object instanceof TreeArea) {
            this.m_treeArea = (TreeArea)object;
        } else {
            System.out.println("Can't register: " + object.getClass());
        }
    }
}

