/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.DirectoryChooser;
import cgdp.recog.ptree.bean.InGroupColorButton;
import cgdp.recog.ptree.bean.OptionSaveButton;
import cgdp.recog.ptree.bean.OutGroupColorButton;
import cgdp.recog.ptree.bean.SpeciesColorButton;
import cgdp.recog.ptree.bean.TreeArea;
import cgdp.recog.ptree.bean.Utils;
import cgdp.recog.ptree.bean.data.OptionTbl;
import cgdp.recog.ptree.bean.data.OptionValues;
import cgdp.recog.ptree.bean.interfaces.CommandImpl;
import cgdp.recog.ptree.bean.interfaces.MediatorImpl;
import cgdp.recog.ptree.bean.interfaces.RecogQueryImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class OptionDialog
extends JDialog
implements ActionListener,
ComponentListener {
    private MediatorImpl m_mediatorImpl;
    private OptionTbl m_optionTbl;
    private TreeArea m_treeArea;
    private int m_width;
    private int m_height;
    private int m_tabIndex;
    private RecogQueryImpl m_queryImpl;
    private JTabbedPane m_tabbed;
    private JTextField m_dndOpenDirTxt;
    private JTextField m_pdfSaveDirTxt;
    private JRadioButton m_symbolNoneBt;
    private JRadioButton m_symbolBoxBt;
    private JRadioButton m_symbolCircleBt;
    private JRadioButton m_spidColorBt;
    private JRadioButton m_outinColorBt;
    private InGroupColorButton m_inGroupColorBt;
    private OutGroupColorButton m_outGroupColorBt;

    public OptionDialog(JFrame jFrame, TreeArea treeArea, MediatorImpl mediatorImpl, int n, RecogQueryImpl recogQueryImpl) {
        super((Frame)jFrame, true);
        this.m_mediatorImpl = mediatorImpl;
        this.m_optionTbl = this.m_mediatorImpl.getOptionTbl();
        this.m_treeArea = treeArea;
        this.m_tabIndex = n;
        this.m_queryImpl = recogQueryImpl;
        this.m_mediatorImpl.register(this);
        this.clear();
        this.setTitle("Option Settings");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OptionDialog.this.m_mediatorImpl.closeOptionDialog();
            }
        });
        this.createComponent();
        this.addComponentListener(this);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    private void clear() {
        this.m_width = 0;
        this.m_height = 0;
    }

    private void createComponent() {
        this.m_tabbed = new JTabbedPane();
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.createDirectory();
        n = Math.max(n, dimension.width);
        n2 = Math.max(n2, dimension.height);
        dimension = this.createStyle();
        n = Math.max(n, dimension.width);
        n2 = Math.max(n2, dimension.height);
        dimension = this.createColors();
        n = Math.max(n, dimension.width);
        n2 = Math.max(n2, dimension.height);
        this.m_tabbed.setPreferredSize(new Dimension(n + 40, n2 + 40));
        this.m_tabbed.setSelectedIndex(this.m_tabIndex);
        this.getContentPane().add((Component)this.m_tabbed, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        this.getContentPane().add((Component)jPanel, "South");
        OptionSaveButton optionSaveButton = new OptionSaveButton(this, this.m_mediatorImpl);
        jPanel.add(optionSaveButton);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.dispose();
            }
        });
    }

    private Dimension createDirectory() {
        OptionValues optionValues = this.m_optionTbl.getOptionValues();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.m_tabbed.add("Directory", jPanel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(new TitledBorder("Directories"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        JLabel jLabel = new JLabel("DND file open directory:");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        this.m_dndOpenDirTxt = new JTextField(30);
        this.m_dndOpenDirTxt.setText(optionValues.getDndOpenDir());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.m_dndOpenDirTxt, gridBagConstraints);
        jPanel4.add(this.m_dndOpenDirTxt);
        DirectoryChooser directoryChooser = new DirectoryChooser(this, this, this.m_mediatorImpl, this.m_dndOpenDirTxt, optionValues.getDndOpenDir());
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(directoryChooser, gridBagConstraints);
        jPanel4.add(directoryChooser);
        jLabel = new JLabel("PDF file save directory:");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        this.m_pdfSaveDirTxt = new JTextField(30);
        this.m_pdfSaveDirTxt.setText(optionValues.getPdfSaveDir());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.m_pdfSaveDirTxt, gridBagConstraints);
        jPanel4.add(this.m_pdfSaveDirTxt);
        directoryChooser = new DirectoryChooser(this, this, this.m_mediatorImpl, this.m_pdfSaveDirTxt, optionValues.getPdfSaveDir());
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(directoryChooser, gridBagConstraints);
        jPanel4.add(directoryChooser);
        return jPanel.getPreferredSize();
    }

    private Dimension createStyle() {
        OptionValues optionValues = this.m_optionTbl.getOptionValues();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.m_tabbed.add("Style", jPanel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(new TitledBorder("Node style"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        JLabel jLabel = new JLabel("Node symbol:");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_symbolNoneBt = new JRadioButton("None");
        buttonGroup.add(this.m_symbolNoneBt);
        this.m_symbolNoneBt.setSelected(optionValues.getNodeSymbol() == 0);
        this.m_symbolNoneBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.changeNodeSymbol(0);
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.m_symbolNoneBt, gridBagConstraints);
        jPanel4.add(this.m_symbolNoneBt);
        this.m_symbolBoxBt = new JRadioButton("Box");
        buttonGroup.add(this.m_symbolBoxBt);
        this.m_symbolBoxBt.setSelected(optionValues.getNodeSymbol() == 1);
        this.m_symbolBoxBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.changeNodeSymbol(1);
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.m_symbolBoxBt, gridBagConstraints);
        jPanel4.add(this.m_symbolBoxBt);
        this.m_symbolCircleBt = new JRadioButton("Circle");
        buttonGroup.add(this.m_symbolCircleBt);
        this.m_symbolCircleBt.setSelected(optionValues.getNodeSymbol() == 2);
        this.m_symbolCircleBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.changeNodeSymbol(2);
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.m_symbolCircleBt, gridBagConstraints);
        jPanel4.add(this.m_symbolCircleBt);
        return jPanel.getPreferredSize();
    }

    private Dimension createColors() {
        OptionValues optionValues = this.m_optionTbl.getOptionValues();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.m_tabbed.add("Color", jPanel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(new TitledBorder("Color type"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = this.m_queryImpl == null ? 0.0 : 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        JLabel jLabel = new JLabel("Type:");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_spidColorBt = new JRadioButton("Species");
        buttonGroup.add(this.m_spidColorBt);
        if (optionValues.getColorType() == 0) {
            this.m_spidColorBt.setSelected(true);
        }
        this.m_spidColorBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.changeColorType();
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints(this.m_spidColorBt, gridBagConstraints);
        jPanel4.add(this.m_spidColorBt);
        this.m_outinColorBt = new JRadioButton("OUT / IN Group");
        buttonGroup.add(this.m_outinColorBt);
        if (optionValues.getColorType() == 1) {
            this.m_outinColorBt.setSelected(true);
        }
        this.m_outinColorBt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.changeColorType();
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints(this.m_outinColorBt, gridBagConstraints);
        jPanel4.add(this.m_outinColorBt);
        if (this.m_queryImpl == null) {
            JComponent jComponent;
            jPanel3 = new JPanel(gridBagLayout);
            jPanel3.setBorder(new TitledBorder("OUT / IN Group Color"));
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel2.add(jPanel3);
            jPanel4 = new JPanel(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
            jPanel3.add(jPanel4);
            Dimension dimension = new Dimension(60, 25);
            Dimension dimension2 = new Dimension(40, 25);
            jLabel = new JLabel("In Group:");
            jLabel.setPreferredSize(dimension);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel4.add(jLabel);
            this.m_inGroupColorBt = new InGroupColorButton(this, this.m_mediatorImpl, optionValues.getInGroupColor());
            this.m_inGroupColorBt.setPreferredSize(dimension2);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 5, 5);
            gridBagLayout.setConstraints(this.m_inGroupColorBt, gridBagConstraints);
            jPanel4.add(this.m_inGroupColorBt);
            jLabel = new JLabel("Out Group:");
            jLabel.setPreferredSize(dimension);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel4.add(jLabel);
            this.m_outGroupColorBt = new OutGroupColorButton(this, this.m_mediatorImpl, optionValues.getOutGroupColor());
            this.m_outGroupColorBt.setPreferredSize(dimension2);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 5, 5);
            gridBagLayout.setConstraints(this.m_outGroupColorBt, gridBagConstraints);
            jPanel4.add(this.m_outGroupColorBt);
            jPanel3 = new JPanel(gridBagLayout);
            jPanel3.setBorder(new TitledBorder("Species Color"));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel2.add(jPanel3);
            jPanel4 = new JPanel(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
            jPanel3.add(jPanel4);
            jLabel = new JLabel("Set plot colors with");
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel4.add(jLabel);
            JPanel jPanel5 = new JPanel(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
            jPanel4.add(jPanel5);
            JPanel jPanel6 = new JPanel(gridBagLayout);
            jPanel6.setBackground(Color.white);
            dimension = new Dimension(30, 25);
            TreeMap treeMap = this.m_treeArea.getSpeciesColorMap();
            Iterator iterator = treeMap.keySet().iterator();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                jLabel = new JLabel(string);
                jLabel.setPreferredSize(dimension);
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = n2++;
                gridBagConstraints.gridy = n;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 0);
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                jPanel6.add(jLabel);
                jComponent = new SpeciesColorButton(this, this.m_mediatorImpl, (String)treeMap.get(string), string);
                jComponent.setPreferredSize(dimension2);
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = n2++;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                jPanel6.add(jComponent);
                if (5 > ++n3) continue;
                n3 = 0;
                n2 = 0;
            }
            jComponent = new JScrollPane(jPanel6);
            Dimension dimension3 = jComponent.getPreferredSize();
            dimension3.width = 500;
            dimension3.height = 100;
            jComponent.setPreferredSize(dimension3);
            if (0 < n) {
                ((JScrollPane)jComponent).getVerticalScrollBar().setUnitIncrement(jPanel6.getPreferredSize().height / n);
            }
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel5.add(jComponent);
        }
        return jPanel.getPreferredSize();
    }

    public void writeOption() throws Exception {
        this.updateOptionValues();
        this.m_optionTbl.writeOption();
    }

    private void updateOptionValues() throws Exception {
        String string = this.getDirValue(this.m_dndOpenDirTxt, "DND file open directory");
        String string2 = this.getDirValue(this.m_dndOpenDirTxt, "PDF file save directory");
        OptionValues optionValues = this.m_optionTbl.getOptionValues();
        optionValues.setDndOpenDir(string);
        optionValues.setPdfSaveDir(string2);
    }

    private String getDirValue(JTextField jTextField, String string) throws Exception {
        String string2 = jTextField.getText();
        if (Utils.isNull(string2)) {
            return "";
        }
        if (new File(string2).exists() && new File(string2).isDirectory()) {
            return string2;
        }
        return System.getProperty("user.dir");
    }

    private void changeNodeSymbol(int n) {
        this.m_mediatorImpl.changeNodeSymbol(n);
    }

    private void changeColorType() {
        try {
            int n = this.m_spidColorBt.isSelected() ? 0 : 1;
            OptionValues optionValues = this.m_optionTbl.getOptionValues();
            optionValues.setColorType(n);
            this.m_treeArea.colorChanged();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            JOptionPane.showMessageDialog(this, "Out of memory error occured.", "Error", 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Apply")) {
            this.m_mediatorImpl.saveOption();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.m_mediatorImpl.closeOptionDialog();
        } else {
            ((CommandImpl)actionEvent.getSource()).execute();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        if (this.m_width == 0) {
            this.m_width = dimension.width;
        }
        if (this.m_height == 0) {
            this.m_height = dimension.height;
        }
        boolean bl = false;
        if (dimension.width < this.m_width) {
            dimension.width = this.m_width;
            bl = true;
        }
        if (dimension.height < this.m_height) {
            dimension.height = this.m_height;
            bl = true;
        }
        if (bl) {
            this.setSize(dimension);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

