/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.BaseShape;
import cgdp.recog.ptree.bean.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.Serializable;

public class TextShape
extends BaseShape {
    public static boolean m_isTransparent;
    protected String m_text;
    protected int m_width;
    protected int m_fontAscent;
    protected Font m_font;
    protected boolean m_isExtented;
    protected Node m_node;

    public TextShape(String string) {
        this.init();
        this.m_text = string;
    }

    public TextShape(String string, Rectangle rectangle) {
        super(rectangle);
        this.init();
        this.m_text = string;
    }

    public TextShape(String string, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.init();
        this.m_text = string;
    }

    protected void init() {
        this.m_text = null;
        this.m_width = 0;
        this.m_fontAscent = -1;
        this.m_font = null;
        this.m_isExtented = false;
        this.m_node = null;
    }

    public static void setTransparent(boolean bl) {
        m_isTransparent = bl;
    }

    public void setText(String string) {
        this.m_text = string;
        this.setExtent();
    }

    public String getText() {
        return this.m_text;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public Node getNode() {
        return this.m_node;
    }

    public void setNode(Node node) {
        this.m_node = node;
    }

    public Object clone() {
        TextShape textShape = (TextShape)super.clone();
        textShape.m_text = this.m_text;
        return textShape;
    }

    protected void setExtent(boolean bl) {
        if (this.m_g != null) {
            FontMetrics fontMetrics = this.m_font != null ? this.m_g.getFontMetrics(this.m_font) : this.m_g.getFontMetrics();
            this.m_fontAscent = fontMetrics.getAscent();
            if (this.m_fontAscent < 0) {
                this.m_fontAscent = this.m_rect.height - 4;
            }
            if (this.m_text != null) {
                this.m_width = fontMetrics.stringWidth(this.m_text) + 2;
            }
            if (bl) {
                int n;
                this.m_rect.height = n = fontMetrics.getHeight();
                this.m_rect.width = this.m_width;
                this.m_rect.grow(2, 1);
            }
            this.m_isExtented = true;
        }
    }

    public void setExtent() {
        this.setExtent(true);
    }

    public void drawShape() {
        int n;
        if (!this.m_isExtented) {
            this.setExtent(false);
        }
        if (this.m_fontAscent < 0) {
            this.m_fontAscent = this.m_rect.height - 4;
        }
        if ((n = (this.m_rect.width - this.m_width) / 2) < 0) {
            n = 2;
        }
        int n2 = this.m_rect.x + n;
        int n3 = this.m_rect.y + this.m_fontAscent;
        if (this.m_text != null) {
            Serializable serializable;
            Font font = this.m_g.getFont();
            if (this.m_font != null) {
                this.m_g.setFont(this.m_font);
            }
            if (!m_isTransparent) {
                serializable = new Rectangle(this.m_rect);
                if (this.m_isMagnify) {
                    ((Rectangle)serializable).x = (int)((double)((Rectangle)serializable).x * this.m_magX);
                    ((Rectangle)serializable).y = (int)((double)((Rectangle)serializable).y * this.m_magY);
                    ((Rectangle)serializable).width = (int)((double)((Rectangle)serializable).width * this.m_magX);
                    ((Rectangle)serializable).height = (int)((double)((Rectangle)serializable).height * this.m_magY);
                }
                ((Rectangle)serializable).grow(-1, -1);
                this.m_g.clearRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                this.m_g.setColor(Color.white);
                this.m_g.fillRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            }
            this.m_g.setColor((Color)((serializable = this.getColor()) != null ? serializable : Color.black));
            if (this.m_isMagnify) {
                n2 = (int)((double)n2 * this.m_magX);
                n3 = (int)((double)n3 * this.m_magY);
            }
            this.m_g.drawString(this.m_text, n2, n3);
            if (this.m_font != null) {
                this.m_g.setFont(font);
            }
            this.m_g.setColor(Color.black);
        }
    }
}

