/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.search.KeywordSearchResult;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ClusterResultTableModel
extends AbstractTableModel {
    private static final String[] COLUMNS = new String[]{"", "Cluster ID", "Gene Name", "Description", "Function Category"};
    private List searchResultList = new ArrayList();
    private boolean outgroupFlag;

    public int getColumnCount() {
        return COLUMNS.length;
    }

    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        if (n == 1) {
            return String.class;
        }
        if (n == 2) {
            return String.class;
        }
        if (n == 3) {
            return FuncCat.class;
        }
        if (n == 4) {
            return FuncCat.class;
        }
        return super.getColumnClass(n);
    }

    public int getRowCount() {
        return this.searchResultList.size();
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public Object getValueAt(int n, int n2) {
        KeywordSearchResult keywordSearchResult = (KeywordSearchResult)this.searchResultList.get(n);
        Cluster cluster = keywordSearchResult.getCluster();
        if (n2 == 0) {
            return new Boolean(keywordSearchResult.isSelected());
        }
        if (n2 == 1) {
            return cluster.getDisplayClusterId();
        }
        if (n2 == 2) {
            return ClusterUtil.getGeneName(cluster, this.outgroupFlag);
        }
        if (n2 == 3) {
            String string = ClusterUtil.getFunctionCategoryNo(cluster, this.outgroupFlag);
            String string2 = ClusterUtil.getDescription(cluster, this.outgroupFlag);
            String string3 = FunctionColorUtil.getFuncCatColorString(string);
            FuncCat funcCat = new FuncCat();
            funcCat.setFunctionCategoryNo(string);
            funcCat.setColor(string3);
            funcCat.setName(string2);
            return funcCat;
        }
        if (n2 == 4) {
            String string = ClusterUtil.getFunctionCategoryNo(cluster, this.outgroupFlag);
            String string4 = string + " " + ClusterUtil.getFunctionCategoryName(cluster, this.outgroupFlag);
            String string5 = FunctionColorUtil.getFuncCatColorString(string);
            FuncCat funcCat = new FuncCat();
            funcCat.setFunctionCategoryNo(string4);
            funcCat.setColor(string5);
            funcCat.setName(string4);
            return funcCat;
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            KeywordSearchResult keywordSearchResult = (KeywordSearchResult)this.searchResultList.get(n);
            keywordSearchResult.setSelected((Boolean)object);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void setSearchResultList(List list) {
        this.searchResultList = list;
        this.fireTableDataChanged();
    }

    public void setSearchResultList(List list, boolean bl) {
        this.searchResultList = list;
        this.outgroupFlag = bl;
        this.fireTableDataChanged();
    }

    public List getSelectedSearchResultList() {
        ArrayList<KeywordSearchResult> arrayList = new ArrayList<KeywordSearchResult>();
        for (KeywordSearchResult keywordSearchResult : this.searchResultList) {
            if (!keywordSearchResult.isSelected()) continue;
            arrayList.add(keywordSearchResult);
        }
        return arrayList;
    }
}

