/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.search.ClusterSearchCondition;
import cgdp.recog.search.ClusterSearchExecuter;
import cgdp.recog.search.KeywordSearchOptionPanel;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ClusterSearchPanel
extends KeywordSearchOptionPanel {
    private MediatorImpl mediator;
    private Container parent;
    private FocusTextField keywordTextField;
    private JRadioButton geneButton;
    private JRadioButton funcCatButton;

    ClusterSearchPanel(Container container, MediatorImpl mediatorImpl) {
        this.parent = container;
        this.mediator = mediatorImpl;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.createSearchTargetPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createKeywordPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel createSearchTargetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.geneButton = new JRadioButton("Gene Name/Description");
        this.funcCatButton = new JRadioButton("Function Category No.");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.geneButton);
        buttonGroup.add(this.funcCatButton);
        this.geneButton.setSelected(true);
        jPanel.add((Component)new JLabel("Search target:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.geneButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.funcCatButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createKeywordPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.keywordTextField = new FocusTextField();
        jPanel.add((Component)new JLabel("Keyword(s):"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.keywordTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private List getKeywordList() {
        String string = this.keywordTextField.getText();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private ClusterSearchCondition getSearchCondition() {
        ClusterSearchCondition clusterSearchCondition = new ClusterSearchCondition(this.getKeywordList(), this.getSearchTarget());
        return clusterSearchCondition;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    protected boolean check() {
        if (StringTool.isNull(this.keywordTextField.getText())) {
            MessageManager.showErrorMessage((Component)this.parent, "Input keywords.");
            return false;
        }
        return true;
    }

    public boolean apply() {
        this.mediator.clearHighlightFilterSearchResult();
        ClusterSearchExecuter clusterSearchExecuter = new ClusterSearchExecuter(this.getSearchCondition());
        this.mediator.executeKeywordSearch(clusterSearchExecuter);
        return false;
    }

    public int getSearchTarget() {
        if (this.geneButton.isSelected()) {
            return 1;
        }
        return 2;
    }
}

