/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.seq;

import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.seq.SeqDownloadCondition;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.CustomFileChooser;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.RestrictTextField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SeqDownloadDialog
extends AbstractApplyDialog {
    private static SeqDownloadDialog SEQ_DOWNLOAD_DIALOG;
    private static JFileChooser CHOOSER;
    private static final String TITLE = "Download sequence";
    private JRadioButton aaButton;
    private JRadioButton ntButton;
    private JLabel upstreamTitleLabel;
    private JLabel downstreamTitleLabel;
    private RestrictTextField upstreamTextField;
    private RestrictTextField downstreamTextField;
    private JRadioButton ppmButton;
    private JRadioButton selectButton;
    private JCheckBox specDelCheckBox;
    private FocusTextField delTextField;
    private JPanel targetPanel;

    private SeqDownloadDialog(Frame frame) {
        super(frame);
        this.createComponents();
        SeqDownloadDialog.createFileChooser();
    }

    public static void createInstance(Frame frame) {
        SEQ_DOWNLOAD_DIALOG = new SeqDownloadDialog(frame);
    }

    public static SeqDownloadDialog getInstance() {
        return SEQ_DOWNLOAD_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.aaButton = new JRadioButton("Protein");
        this.aaButton.addActionListener(this);
        this.ntButton = new JRadioButton("DNA");
        this.ntButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.aaButton);
        buttonGroup.add(this.ntButton);
        this.aaButton.setSelected(true);
        this.targetPanel = this.createTargetPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.aaButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.ntButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.createNTRangePanel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 15, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.createDelPanel(), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.targetPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.setEnableDNAOption();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createNTRangePanel() {
        this.upstreamTitleLabel = new JLabel("Additional bases : upstream :");
        this.downstreamTitleLabel = new JLabel("downstream :");
        this.upstreamTextField = new RestrictTextField(6);
        this.downstreamTextField = new RestrictTextField(6);
        this.upstreamTextField.setRestrict(3);
        this.downstreamTextField.setRestrict(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.upstreamTitleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.upstreamTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.downstreamTitleLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.downstreamTextField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createTargetPanel() {
        JLabel jLabel = new JLabel("Target genes");
        this.ppmButton = new JRadioButton("Entire cluster table");
        this.selectButton = new JRadioButton("Selected cluster(s) only");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ppmButton);
        buttonGroup.add(this.selectButton);
        this.selectButton.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.ppmButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.selectButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        return jPanel;
    }

    private JPanel createDelPanel() {
        this.specDelCheckBox = new JCheckBox("Delimiter between CDS and UTR");
        this.specDelCheckBox.addActionListener(this);
        this.delTextField = new FocusTextField(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.specDelCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.delTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(boolean bl) {
        this.targetPanel.setVisible(bl);
        this.pack();
    }

    private void setEnableDNAOption() {
        this.upstreamTextField.setEnabled(this.ntButton.isSelected());
        this.downstreamTextField.setEnabled(this.ntButton.isSelected());
        this.specDelCheckBox.setEnabled(this.ntButton.isSelected());
        this.delTextField.setEnabled(this.ntButton.isSelected() && this.specDelCheckBox.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.aaButton || actionEvent.getSource() == this.ntButton) {
            this.setEnableDNAOption();
        } else if (actionEvent.getSource() == this.specDelCheckBox) {
            this.setEnableDNAOption();
        }
    }

    private String getSeqType() {
        if (this.aaButton.isSelected()) {
            return "aaseq";
        }
        return "ntseq";
    }

    private int getUpstream() {
        int n = 0;
        try {
            n = Integer.parseInt(this.upstreamTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    private int getDownstream() {
        int n = 0;
        try {
            n = Integer.parseInt(this.downstreamTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    private String getDelStr() {
        return this.delTextField.getText();
    }

    private boolean isSpecDel() {
        return this.specDelCheckBox.isSelected();
    }

    private String getTargetType() {
        String string = "select";
        if (this.ppmButton.isSelected()) {
            string = "ppm";
        }
        return string;
    }

    public SeqDownloadCondition createCondition() {
        SeqDownloadCondition seqDownloadCondition = new SeqDownloadCondition();
        seqDownloadCondition.setSeqType(this.getSeqType());
        seqDownloadCondition.setUpstream(this.getUpstream());
        seqDownloadCondition.setDownstream(this.getDownstream());
        seqDownloadCondition.setSpecDel(this.isSpecDel());
        seqDownloadCondition.setDelStr(this.getDelStr());
        seqDownloadCondition.setTargetType(this.getTargetType());
        return seqDownloadCondition;
    }

    protected boolean apply() {
        return true;
    }

    private static void createFileChooser() {
        CHOOSER = new CustomFileChooser();
        CHOOSER.setDialogTitle(TITLE);
        CHOOSER.addChoosableFileFilter(FileFilterFactory.createFastAFileFilter());
    }

    public static JFileChooser getChooser() {
        return CHOOSER;
    }
}

