/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.ColorFacade;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.info.ElementInfo;
import cgdp.recog.info.LocationType;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.SetColorPatternFactory;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.set.SetType;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.set.venn.VennClusterListDialog;
import cgdp.recog.set.venn.VennGeneInfoListDialog;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractElementSetFacade {
    protected static List getNewElementSetList(List list) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : list) {
            if (!abstractElementSet.isNew()) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    protected static Map createElementSetMap(Collection collection) {
        HashMap<String, AbstractElementSet> hashMap = new HashMap<String, AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : collection) {
            hashMap.put(abstractElementSet.getKey(), abstractElementSet);
        }
        return hashMap;
    }

    protected static Map createNameElementSetMap(Collection collection) {
        HashMap<String, AbstractElementSet> hashMap = new HashMap<String, AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : collection) {
            hashMap.put(abstractElementSet.getName(), abstractElementSet);
        }
        return hashMap;
    }

    public static Map createSetElementListMap(Collection collection) {
        HashMap<AbstractElementSet, List> hashMap = new HashMap<AbstractElementSet, List>();
        for (AbstractElementSet abstractElementSet : collection) {
            List list = AbstractElementSetFacade.getElementList(abstractElementSet);
            hashMap.put(abstractElementSet, list);
        }
        return hashMap;
    }

    public static List getElementSetNameList(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AbstractElementSet abstractElementSet : collection) {
            arrayList.add(abstractElementSet.getName());
        }
        return arrayList;
    }

    public static String getElementSetNameString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (AbstractElementSet abstractElementSet : collection) {
            stringBuffer.append(abstractElementSet.getName());
            if (n != collection.size() - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static void removeListFile(List list, List list2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : list) {
            Object object2 = ((AbstractElementSet)object).getFilepath();
            if (StringTool.isNull((String)object2)) continue;
            hashSet.add((String)object2);
        }
        HashSet hashSet2 = new HashSet();
        for (Object object2 : list2) {
            String string = ((AbstractElementSet)object2).getFilepath();
            if (StringTool.isNull(string) || hashSet.contains(string)) continue;
            hashSet2.add(object2);
        }
        AbstractElementSetFacade.removeListFile(hashSet2);
    }

    protected static void removeListFile(Collection collection) {
        for (AbstractElementSet abstractElementSet : collection) {
            AbstractElementSetFacade.removeListFile(abstractElementSet);
        }
    }

    protected static void removeListFile(AbstractElementSet abstractElementSet) {
        FileUtil.delete(new File(abstractElementSet.getFilepath()));
    }

    public void deleteElementListFromSet(MediatorImpl mediatorImpl, AbstractElementSet abstractElementSet, Collection collection) throws Exception {
        Object object;
        Object object22;
        List list = this.importElementList(abstractElementSet);
        Set set = this.getKeySet(collection);
        HashSet<ElementInfo> hashSet = new HashSet<ElementInfo>();
        for (Object object22 : list) {
            object = object22.getKey();
            if (!set.contains(object)) continue;
            hashSet.add((ElementInfo)object22);
        }
        list.removeAll(hashSet);
        abstractElementSet.setElementList(list);
        List list2 = this.getElementSetList();
        object22 = list2.iterator();
        while (object22.hasNext()) {
            object = (AbstractElementSet)object22.next();
            if (!((AbstractElementSet)object).equalsElement(abstractElementSet)) continue;
            Collections.replaceAll(list2, object, abstractElementSet);
            break;
        }
        this.exportConfFile(list2);
        this.exportListFile(abstractElementSet, list);
        this.updateSetTree(mediatorImpl);
    }

    public static boolean containsElementSetGroup(Collection collection, ElementSetGroup elementSetGroup) {
        for (ElementSetGroup elementSetGroup2 : collection) {
            if (!elementSetGroup2.equalsGroupCondition(elementSetGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsElementSet(Collection collection, AbstractElementSet abstractElementSet) {
        for (AbstractElementSet abstractElementSet2 : collection) {
            if (!abstractElementSet2.equalsElement(abstractElementSet)) continue;
            return true;
        }
        return false;
    }

    public static List getElementSetList(int n, String string) {
        List list = SetType.isGeneSet(n) ? GeneSetFacade.getInstance().getGeneSetListGlobalCurrectProject() : ClusterSetFacade.getInstance().getClusterSetListCurrentDomClust(string);
        return list;
    }

    public static void addSetCondition(SetConditionGroup setConditionGroup, SetCondition setCondition) {
        setConditionGroup.addSetCondition(setCondition);
    }

    public static void addSetCondition(SetConditionGroup setConditionGroup, SetCondition setCondition, boolean bl, boolean bl2) {
        Object object;
        setConditionGroup.addSetCondition(setCondition);
        if (bl) {
            object = FilterFacade.getInstance();
            ((FilterFacade)object).addSetCondition(setCondition);
        }
        if (bl2) {
            object = ColorFacade.getInstance();
            ((ColorFacade)object).addSetColorDrawable(setCondition);
        }
    }

    public static void editSetCondition(SetConditionGroup setConditionGroup, SetCondition setCondition, SetCondition setCondition2, boolean bl, boolean bl2) {
        Object object;
        setCondition.copy(setCondition2);
        if (bl) {
            object = FilterFacade.getInstance();
            ((FilterFacade)object).addSetCondition(setCondition2);
        }
        if (bl2) {
            object = ColorFacade.getInstance();
            ((ColorFacade)object).addSetColorDrawable(setCondition2);
        }
    }

    public static void removeSetCondition(SetConditionGroup setConditionGroup, SetCondition setCondition) {
        setConditionGroup.removeSetCondition(setCondition);
        FilterFacade.getInstance().removeSetCondition(setCondition);
        ColorFacade.getInstance().removeSetColorDrawable(setCondition);
    }

    public static void removeSetCondition(SetConditionGroup setConditionGroup, Collection collection) {
        for (SetCondition setCondition : collection) {
            AbstractElementSetFacade.removeSetCondition(setConditionGroup, setCondition);
        }
    }

    public static void removeElementSetGroup(SetConditionGroup setConditionGroup, SetCondition setCondition, List list) {
        setCondition.removeElementSetGroup(list);
        if (!setCondition.isExistElementSetGroup()) {
            setConditionGroup.removeSetCondition(setCondition);
            FilterFacade.getInstance().removeSetCondition(setCondition);
            ColorFacade.getInstance().removeSetColorDrawable(setCondition);
        }
    }

    public static void removeElementSet(SetConditionGroup setConditionGroup, SetCondition setCondition, List list) {
        setCondition.removeElementSet(list);
        if (!setCondition.isExistElementSetGroup()) {
            setConditionGroup.removeSetCondition(setCondition);
            ColorFacade.getInstance().removeSetColorDrawable(setCondition);
        }
    }

    public static Set removeElementSetFromSetCondition(SetConditionGroup setConditionGroup, Collection collection) {
        Set set = setConditionGroup.removeElementSet(collection);
        if (!CollectionUtil.isNull(set)) {
            ColorFacade.getInstance().removeSetColorDrawable(set);
        }
        return set;
    }

    public abstract List importElementList(AbstractElementSet var1);

    protected abstract Set getKeySet(Collection var1);

    public abstract List getElementSetList();

    protected abstract void exportConfFile(List var1) throws Exception;

    protected abstract void exportListFile(AbstractElementSet var1, List var2) throws Exception;

    protected abstract void updateSetTree(MediatorImpl var1);

    public void deleteElementSet(Collection collection) throws Exception {
        List list = this.getElementSetList();
        Map map = AbstractElementSetFacade.createElementSetMap(collection);
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : list) {
            String string = abstractElementSet.getKey();
            if (map.containsKey(string)) continue;
            arrayList.add(abstractElementSet);
        }
        this.exportConfFile(arrayList);
        AbstractElementSetFacade.removeListFile(collection);
    }

    public void registerElementSetList(List list) throws Exception {
        List list2 = AbstractElementSetFacade.getLocalSetList(list);
        List list3 = this.getElementSetList();
        this.exportConfFile(list2);
        for (AbstractElementSet abstractElementSet : list2) {
            if (!abstractElementSet.isNew() && !abstractElementSet.isEditList() && !abstractElementSet.isEditLocation()) continue;
            this.exportListFile(abstractElementSet, abstractElementSet.getElementList());
        }
        AbstractElementSetFacade.removeListFile(list2, list3);
    }

    public AbstractElementSet getSameElementSet(AbstractElementSet abstractElementSet) {
        List list = this.getElementSetList();
        return AbstractElementSetFacade.getSameElementSet(abstractElementSet, list);
    }

    public static AbstractElementSet getSameElementSet(AbstractElementSet abstractElementSet, List list) {
        for (AbstractElementSet abstractElementSet2 : list) {
            if (!abstractElementSet2.equalsElement(abstractElementSet)) continue;
            return abstractElementSet2;
        }
        return null;
    }

    public static Map createElementSetMap() {
        List list = GeneSetFacade.getInstance().getElementSetList();
        List list2 = ClusterSetFacade.getInstance().getElementSetList();
        HashMap<String, AbstractElementSet> hashMap = new HashMap<String, AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : list) {
            hashMap.put(abstractElementSet.getId(), abstractElementSet);
        }
        for (AbstractElementSet abstractElementSet : list2) {
            hashMap.put(abstractElementSet.getId(), abstractElementSet);
        }
        return hashMap;
    }

    public static List getElementList(AbstractElementSet abstractElementSet) {
        List list = new ArrayList();
        if (abstractElementSet.isGeneSet()) {
            list = GeneSetFacade.getInstance().importElementList(abstractElementSet);
        } else if (abstractElementSet.isClusterSet()) {
            list = ClusterSetFacade.getInstance().importElementList(abstractElementSet);
        }
        return list;
    }

    public static AbstractElementSet intersect(Set set) {
        if (set.size() == 1) {
            return (AbstractElementSet)set.iterator().next();
        }
        Iterator iterator = set.iterator();
        AbstractElementSet abstractElementSet = (AbstractElementSet)iterator.next();
        while (iterator.hasNext()) {
            AbstractElementSet abstractElementSet2 = (AbstractElementSet)iterator.next();
            if ((abstractElementSet = abstractElementSet.intersect(abstractElementSet2)).isExistElement()) continue;
            return abstractElementSet;
        }
        return abstractElementSet;
    }

    public static int getSetType(List list) {
        if (CollectionUtil.isNull(list)) {
            return -1;
        }
        return ((AbstractElementSet)list.get(0)).getSetType();
    }

    public static boolean validateExistElementList(Component component, int n, List list) {
        if (CollectionUtil.isNull(list)) {
            String string = SetType.isGeneSet(n) ? "There is no genes" : "There is no clusters";
            MessageManager.showMessage(component, string);
            return false;
        }
        return true;
    }

    public static void showInfoListDialog(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, int n, List list) {
        if (!AbstractElementSetFacade.validateExistElementList(component, n, list)) {
            return;
        }
        if (SetType.isGeneSet(n)) {
            VennGeneInfoListDialog vennGeneInfoListDialog = VennGeneInfoListDialog.getInstance(component, mediatorImpl);
            vennGeneInfoListDialog.updateValue(list);
            vennGeneInfoListDialog.setVisible(true);
        } else if (SetType.isClusterSet(n)) {
            VennClusterListDialog vennClusterListDialog = VennClusterListDialog.getInstance(component, mediatorImpl, clusterTbl);
            vennClusterListDialog.updateValue(list);
            vennClusterListDialog.setVisible(true);
        }
    }

    public static List createDefaultElementSetGroupListForVenn(List list) {
        ArrayList<ElementSetGroup> arrayList = new ArrayList<ElementSetGroup>();
        if (CollectionUtil.isNull(list)) {
            return arrayList;
        }
        if (list.size() == 1) {
            Color[] colorArray = SetColorPatternFactory.createPaintArray();
            AbstractElementSet abstractElementSet = (AbstractElementSet)list.get(0);
            ElementSetGroup elementSetGroup = new ElementSetGroup(abstractElementSet);
            elementSetGroup.setColor(colorArray[0]);
            arrayList.add(elementSetGroup);
        } else if (list.size() == 2) {
            Color[] colorArray = SetColorPatternFactory.getTwoSetColors();
            ElementSetGroup elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[0]);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[1]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(0), true);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[2]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(1), true);
            arrayList.add(elementSetGroup);
        } else if (list.size() == 3) {
            Color[] colorArray = SetColorPatternFactory.getThreeSetColors();
            ElementSetGroup elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[0]);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[1]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(2), true);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[2]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(0), true);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[3]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(1), true);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[4]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(1), true);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(2), true);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[5]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(0), true);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(2), true);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[6]);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(0), true);
            elementSetGroup.setNotMap((AbstractElementSet)list.get(1), true);
            arrayList.add(elementSetGroup);
        } else {
            Color[] colorArray = SetColorPatternFactory.createPaintArray();
            int n = 0;
            ElementSetGroup elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[n % colorArray.length]);
            arrayList.add(elementSetGroup);
            ++n;
            for (AbstractElementSet abstractElementSet : list) {
                elementSetGroup = new ElementSetGroup(list);
                elementSetGroup.setColor(colorArray[n % colorArray.length]);
                HashSet hashSet = new HashSet(list);
                hashSet.remove(abstractElementSet);
                elementSetGroup.setNotMap(hashSet, true);
                arrayList.add(elementSetGroup);
                ++n;
            }
        }
        return arrayList;
    }

    public static List createDefaultElementSetGroupListForList(List list) {
        ArrayList<ElementSetGroup> arrayList = new ArrayList<ElementSetGroup>();
        if (CollectionUtil.isNull(list)) {
            return arrayList;
        }
        if (list.size() == 1) {
            Color[] colorArray = SetColorPatternFactory.createPaintArray();
            AbstractElementSet abstractElementSet = (AbstractElementSet)list.get(0);
            ElementSetGroup elementSetGroup = new ElementSetGroup(abstractElementSet);
            elementSetGroup.setColor(colorArray[0]);
            arrayList.add(elementSetGroup);
        } else if (list.size() == 2) {
            Color[] colorArray = SetColorPatternFactory.getTwoSetColors();
            ElementSetGroup elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[0]);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup((AbstractElementSet)list.get(0));
            elementSetGroup.setColor(colorArray[1]);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup((AbstractElementSet)list.get(1));
            elementSetGroup.setColor(colorArray[2]);
            arrayList.add(elementSetGroup);
        } else if (list.size() == 3) {
            Color[] colorArray = SetColorPatternFactory.getThreeSetColors();
            ElementSetGroup elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[0]);
            arrayList.add(elementSetGroup);
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(list.get(0));
            arrayList2.add(list.get(1));
            elementSetGroup = new ElementSetGroup(arrayList2);
            elementSetGroup.setColor(colorArray[1]);
            arrayList.add(elementSetGroup);
            ArrayList arrayList3 = new ArrayList();
            arrayList3.add(list.get(1));
            arrayList3.add(list.get(2));
            elementSetGroup = new ElementSetGroup(arrayList3);
            elementSetGroup.setColor(colorArray[2]);
            arrayList.add(elementSetGroup);
            ArrayList arrayList4 = new ArrayList();
            arrayList4.add(list.get(0));
            arrayList4.add(list.get(2));
            elementSetGroup = new ElementSetGroup(arrayList4);
            elementSetGroup.setColor(colorArray[3]);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup((AbstractElementSet)list.get(0));
            elementSetGroup.setColor(colorArray[4]);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup((AbstractElementSet)list.get(1));
            elementSetGroup.setColor(colorArray[5]);
            arrayList.add(elementSetGroup);
            elementSetGroup = new ElementSetGroup((AbstractElementSet)list.get(2));
            elementSetGroup.setColor(colorArray[6]);
            arrayList.add(elementSetGroup);
        } else {
            Color[] colorArray = SetColorPatternFactory.createPaintArray();
            int n = 0;
            ElementSetGroup elementSetGroup = new ElementSetGroup(list);
            elementSetGroup.setColor(colorArray[n % colorArray.length]);
            arrayList.add(elementSetGroup);
            ++n;
            for (AbstractElementSet abstractElementSet : list) {
                elementSetGroup = new ElementSetGroup(abstractElementSet);
                elementSetGroup.setColor(colorArray[n % colorArray.length]);
                arrayList.add(elementSetGroup);
                ++n;
            }
        }
        return arrayList;
    }

    public static List subtractElementSetList(Collection collection, Collection collection2) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : collection) {
            boolean bl = false;
            for (AbstractElementSet abstractElementSet2 : collection2) {
                if (!abstractElementSet.equalsElement(abstractElementSet2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    public static BitSet createBitSet(List list, ElementSetGroup elementSetGroup) {
        BitSet bitSet = new BitSet(list.size());
        for (int i = 0; i < list.size(); ++i) {
            AbstractElementSet abstractElementSet = (AbstractElementSet)list.get(i);
            bitSet.set(i, !elementSetGroup.isNot(abstractElementSet));
        }
        return bitSet;
    }

    public static List splitElementSetGroupList(List list, List list2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ElementSetGroup elementSetGroup : list2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            List list3 = elementSetGroup.getElementSetList();
            if (list3.size() == list.size()) {
                object4 = AbstractElementSetFacade.createBitSet(list, elementSetGroup);
                if (hashSet.contains(object4)) continue;
                arrayList.add(elementSetGroup);
                hashSet.add(object4);
                continue;
            }
            object4 = AbstractElementSetFacade.subtractElementSetList(list, list3);
            int n = object4.size();
            Object object5 = new ArrayList<ElementSetGroup>();
            object5.add(elementSetGroup);
            for (int i = 0; i < n; ++i) {
                object3 = new ArrayList();
                object2 = (AbstractElementSet)object4.get(i);
                object = object5.iterator();
                while (object.hasNext()) {
                    ElementSetGroup elementSetGroup2 = (ElementSetGroup)object.next();
                    ElementSetGroup elementSetGroup3 = (ElementSetGroup)elementSetGroup2.clone();
                    ElementSetGroup elementSetGroup4 = (ElementSetGroup)elementSetGroup2.clone();
                    elementSetGroup3.addElementSet((AbstractElementSet)object2, false);
                    elementSetGroup4.addElementSet((AbstractElementSet)object2, true);
                    object3.add(elementSetGroup3);
                    object3.add(elementSetGroup4);
                }
                object5 = object3;
            }
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (ElementSetGroup)object3.next();
                object = AbstractElementSetFacade.createBitSet(list, (ElementSetGroup)object2);
                if (hashSet.contains(object)) continue;
                arrayList.add(object2);
                hashSet.add(object);
            }
        }
        return arrayList;
    }

    public static boolean equalsElementSetGroupList(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection2);
        for (ElementSetGroup elementSetGroup : collection) {
            boolean bl = false;
            for (ElementSetGroup elementSetGroup2 : hashSet) {
                if (!elementSetGroup.equalsGroup(elementSetGroup2)) continue;
                hashSet.remove(elementSetGroup2);
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return hashSet.isEmpty();
    }

    public static List eliminateDuplicateElement(List list, int n) {
        if (SetType.isGeneSet(n)) {
            return GeneSetFacade.eliminateDuplicateElement(list);
        }
        return ClusterSetFacade.eliminateDuplicateElement(list);
    }

    public static Map createSetBitsInfoMap(int n, List list, Map map) {
        if (SetType.isGeneSet(n)) {
            return GeneSetFacade.createSetBitsInfoMap(list, map);
        }
        return ClusterSetFacade.createSetBitsInfoMap(list, map);
    }

    public static String createElementSetNameString(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AbstractElementSet abstractElementSet : collection) {
            arrayList.add(abstractElementSet.getName());
        }
        return StringTool.conbineStrList(arrayList, ",");
    }

    public static boolean validateSet(Component component, List list) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (Object[] objectArray : list) {
            AbstractElementSet abstractElementSet = null;
            abstractElementSet = objectArray.isGeneSet() ? GeneSetFacade.getInstance().getSameElementSet((AbstractElementSet)objectArray) : ClusterSetFacade.getInstance().getSameElementSet((AbstractElementSet)objectArray);
            if (abstractElementSet == null) continue;
            arrayList.add(abstractElementSet);
        }
        if (!CollectionUtil.isNull(arrayList)) {
            Object[] objectArray;
            String string = AbstractElementSetFacade.createElementSetNameString(arrayList);
            objectArray = new String[]{"You have already made set [" + (String)string + "].", "Overwrite the set [" + (String)string + "]?"};
            if (!MessageManager.showConfirmMessage(component, objectArray)) {
                return false;
            }
        }
        return true;
    }

    public static List getServerSetList(Collection collection) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : collection) {
            if (!LocationType.isNameServer(abstractElementSet.getLocation())) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }

    public static List getLocalSetList(Collection collection) {
        ArrayList<AbstractElementSet> arrayList = new ArrayList<AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : collection) {
            if (LocationType.isNameServer(abstractElementSet.getLocation())) continue;
            arrayList.add(abstractElementSet);
        }
        return arrayList;
    }
}

