/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.active.ColorActivation;
import cgdp.recog.active.FilterActivation;
import cgdp.recog.data.Cluster;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.ElementSetComparator;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.SetType;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class SetCondition
implements FilterActivation,
ColorActivation {
    public static final int FILTER_AND_COLOR = 1;
    public static final int FILTER = 2;
    public static final int COLOR = 3;
    public static final int NO_ACTION = -1;
    public static final String PREFIX_SINGLE = "##";
    private int setType;
    private String name;
    private List elementSetGroupList = new ArrayList();
    private Color noMatchColor = ColorUtil.str2Color("#008000");
    private boolean syncEnable = false;
    private boolean combination = true;

    public int getSetType() {
        return this.setType;
    }

    public void setSetType(int n) {
        this.setType = n;
    }

    public boolean isClusterSet() {
        return SetType.isClusterSet(this.getSetType());
    }

    public boolean isGeneSet() {
        return SetType.isGeneSet(this.getSetType());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        String string = this.getName();
        if (string.startsWith(PREFIX_SINGLE)) {
            string = string.substring(PREFIX_SINGLE.length());
        }
        return string;
    }

    public Color getNoMatchColor() {
        return this.noMatchColor;
    }

    public void setNoMatchColor(Color color) {
        this.noMatchColor = color;
    }

    public boolean isCombination() {
        return this.combination;
    }

    public void setCombination(boolean bl) {
        this.combination = bl;
    }

    public List getElementSetGroupList() {
        return this.elementSetGroupList;
    }

    public List getElementSetList() {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<AbstractElementSet> hashSet2 = new HashSet<AbstractElementSet>();
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            for (AbstractElementSet abstractElementSet : elementSetGroup.getElementSetList()) {
                if (hashSet.contains(abstractElementSet.getKey())) continue;
                hashSet.add(abstractElementSet.getKey());
                hashSet2.add(abstractElementSet);
            }
        }
        ArrayList arrayList = new ArrayList(hashSet2);
        Collections.sort(arrayList, new ElementSetComparator());
        return arrayList;
    }

    public void setElementSetGroupList(List list) {
        this.elementSetGroupList = list;
        for (ElementSetGroup elementSetGroup : this.elementSetGroupList) {
            elementSetGroup.setSetCondition(this);
        }
    }

    public void addElementSetGroup(ElementSetGroup elementSetGroup) {
        this.elementSetGroupList.add(elementSetGroup);
        elementSetGroup.setSetCondition(this);
    }

    public void removeElementSetGroup(Collection collection) {
        HashSet<ElementSetGroup> hashSet = new HashSet<ElementSetGroup>();
        for (ElementSetGroup elementSetGroup : collection) {
            ElementSetGroup elementSetGroup2 = this.find(elementSetGroup);
            if (elementSetGroup2 == null) continue;
            hashSet.add(elementSetGroup);
        }
        this.elementSetGroupList.removeAll(hashSet);
        for (ElementSetGroup elementSetGroup : hashSet) {
            elementSetGroup.clearSetCondition();
        }
    }

    public void removeElementSet(Collection collection) {
        HashSet<ElementSetGroup> hashSet = new HashSet<ElementSetGroup>();
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            if (!elementSetGroup.containsElementSet(collection)) continue;
            hashSet.add(elementSetGroup);
        }
        this.removeElementSetGroup(hashSet);
    }

    private ElementSetGroup find(ElementSetGroup elementSetGroup) {
        for (ElementSetGroup elementSetGroup2 : this.elementSetGroupList) {
            if (!elementSetGroup2.equalsGroup(elementSetGroup)) continue;
            return elementSetGroup2;
        }
        return null;
    }

    public boolean isExistElementSetGroup() {
        return !CollectionUtil.isNull(this.elementSetGroupList);
    }

    public void flipFilterActive() {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            elementSetGroup.flipFilterActive();
            if (!this.isSyncEnable()) continue;
            elementSetGroup.flipColorActive();
        }
    }

    public boolean isFilterActive() {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            if (!elementSetGroup.isFilterActive()) continue;
            return true;
        }
        return false;
    }

    public void setFilterActive(boolean bl) {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            elementSetGroup.setFilterActive(bl);
            if (!this.isSyncEnable()) continue;
            elementSetGroup.setColorActive(bl);
        }
    }

    public void flipColorActive() {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            elementSetGroup.flipColorActive();
            if (!this.isSyncEnable()) continue;
            elementSetGroup.flipFilterActive();
        }
    }

    public boolean isColorActive() {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            if (!elementSetGroup.isColorActive()) continue;
            return true;
        }
        return false;
    }

    public void setColorActive(boolean bl) {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            elementSetGroup.setColorActive(bl);
            if (!this.isSyncEnable()) continue;
            elementSetGroup.setFilterActive(bl);
        }
    }

    public void updateElementList() {
        HashSet hashSet = new HashSet();
        for (Object object : this.elementSetGroupList) {
            hashSet.addAll(((ElementSetGroup)object).getElementSetList());
        }
        for (Object object : hashSet) {
            ((AbstractElementSet)object).updateElementList();
        }
    }

    public boolean equalsSetCondition(SetCondition setCondition) {
        if (setCondition == null) {
            return false;
        }
        return setCondition.getName().equals(this.getName());
    }

    public boolean isMatchFilter(Collection collection) {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            if (!elementSetGroup.isFilterActive() || !elementSetGroup.isMatch(collection)) continue;
            return true;
        }
        return false;
    }

    public void copy(SetCondition setCondition) {
        this.setName(setCondition.getName());
        this.setElementSetGroupList(setCondition.getElementSetGroupList());
        this.setSetType(setCondition.getSetType());
        this.setNoMatchColor(setCondition.getNoMatchColor());
        this.setSyncEnable(setCondition.isSyncEnable());
    }

    public boolean isMatch(Cluster cluster) {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            if (!elementSetGroup.isMatch(cluster)) continue;
            return true;
        }
        return false;
    }

    public boolean containsByColorCondition(Cluster cluster, String string) {
        for (ElementSetGroup elementSetGroup : this.getElementSetGroupList()) {
            if (!elementSetGroup.isColorActive() || !elementSetGroup.isMatch(cluster, string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSyncEnable() {
        return this.syncEnable;
    }

    public void setSyncEnable(boolean bl) {
        this.syncEnable = bl;
    }

    public static int getFilterColorAction(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return 3;
        }
        return -1;
    }
}

