/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.SetDeleteAfterRunnable;
import cgdp.recog.set.SetDeleteRequester;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class SetDeleteRequestExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(SetDeleteRequestExecuter.class);
    private Component parent;
    private Collection setC;
    private List unableDeleteSetList = new ArrayList();

    public SetDeleteRequestExecuter(Component component, Collection collection) {
        this.parent = component;
        this.setC = collection;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.setC.size());
        try {
            Iterator iterator = this.setC.iterator();
            while (iterator.hasNext()) {
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                AbstractElementSet abstractElementSet = (AbstractElementSet)iterator.next();
                SetDeleteRequester setDeleteRequester = new SetDeleteRequester(abstractElementSet);
                try {
                    setDeleteRequester.execute();
                }
                catch (Exception exception) {
                    String string = "Fail to delete set. " + abstractElementSet.getName();
                    logger.warn(string, exception);
                    this.unableDeleteSetList.add(abstractElementSet);
                }
            }
        }
        catch (Exception exception) {
            String string = "Fail to delete gene properties.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!CollectionUtil.isNull(this.unableDeleteSetList)) {
            String[] stringArray = new String[]{"Fail to delete the follow sets.", AbstractElementSetFacade.createElementSetNameString(this.unableDeleteSetList)};
            MessageManager.showErrorMessage(this.parent, stringArray);
            return;
        }
        if (this.getAfterRunnable() != null) {
            SetDeleteAfterRunnable setDeleteAfterRunnable = (SetDeleteAfterRunnable)this.getAfterRunnable();
            setDeleteAfterRunnable.setUnableDeleteSetC(this.unableDeleteSetList);
            SwingUtilities.invokeLater(setDeleteAfterRunnable);
        }
    }
}

