/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.set.SetConditionUtil;
import cgdp.recog.set.SetFilterColorActionPanel;
import cgdp.recog.set.SetType;
import cgdp.recog.set.cluster.ClusterSetCondition;
import cgdp.recog.set.gene.GeneSetCondition;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ColorLegendPanel;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class SetFilterColorDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Set Filter and Color Setting";
    private static SetFilterColorDialog SET_FILTER_COLOR_DIALOG;
    private FocusTextField nameTextField;
    private ColorLegendPanel colorLegendPanel;
    private SetFilterColorActionPanel setFilterColorActionPanel;
    private AbstractElementSet elementSet;
    private SetConditionGroup setConditionGroup;

    private SetFilterColorDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public static final void createInstance(Frame frame) {
        SET_FILTER_COLOR_DIALOG = new SetFilterColorDialog(frame);
    }

    public static final SetFilterColorDialog getInstance() {
        return new SetFilterColorDialog((Frame)SET_FILTER_COLOR_DIALOG.getParent());
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField(30);
        JLabel jLabel2 = new JLabel("Color");
        this.colorLegendPanel = new ColorLegendPanel(Color.red);
        this.setFilterColorActionPanel = new SetFilterColorActionPanel();
        this.setFilterColorActionPanel.setBorder(BorderFactory.createTitledBorder("Filter/Color setting"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.colorLegendPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.setFilterColorActionPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(AbstractElementSet abstractElementSet, SetConditionGroup setConditionGroup, int n) {
        this.elementSet = abstractElementSet;
        this.setConditionGroup = setConditionGroup;
        String string = SetConditionUtil.createDefaultName(abstractElementSet.getName(), abstractElementSet.getSetType(), setConditionGroup);
        this.nameTextField.setText(string);
        this.setFilterColorActionPanel.updateValue(1, false);
    }

    private String getConditionName() {
        return this.nameTextField.getText();
    }

    protected boolean check() {
        if (StringTool.isNull(this.getConditionName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        if (this.setConditionGroup.containsSetName(this.elementSet.getSetType(), this.getConditionName())) {
            MessageManager.showErrorMessage((Component)this, "Duplicate name [" + this.getConditionName() + "].");
            return false;
        }
        return true;
    }

    protected boolean apply() {
        return true;
    }

    public boolean isAddColor() {
        return this.setFilterColorActionPanel.isAddColor();
    }

    public boolean isAddFilter() {
        return this.setFilterColorActionPanel.isAddFilter();
    }

    private Color getColor() {
        return this.colorLegendPanel.getBackground();
    }

    public SetCondition createSetCondition() {
        ElementSetGroup elementSetGroup = new ElementSetGroup();
        elementSetGroup.addElementSet(this.elementSet, false);
        elementSetGroup.setColor(this.getColor());
        ArrayList<ElementSetGroup> arrayList = new ArrayList<ElementSetGroup>();
        arrayList.add(elementSetGroup);
        SetCondition setCondition = SetType.isClusterSet(this.elementSet.getSetType()) ? new ClusterSetCondition() : new GeneSetCondition();
        setCondition.setSetType(this.elementSet.getSetType());
        setCondition.setCombination(false);
        setCondition.setElementSetGroupList(arrayList);
        setCondition.setName("##" + this.getConditionName());
        setCondition.updateElementList();
        return setCondition;
    }
}

