/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.CombinationEditDialog;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.ElementSetGroupLabelColor;
import cgdp.recog.set.SetColorPatternFactory;
import cgdp.recog.set.SetCombinationControlButtonPanel;
import cgdp.recog.set.SetCombinationModel;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.set.SetConditionUtil;
import cgdp.recog.set.SetConditionValidateCondition;
import cgdp.recog.set.SetConditionValidater;
import cgdp.recog.set.SetFilterColorActionPanel;
import cgdp.recog.set.SetNameTableModel;
import cgdp.recog.set.SetType;
import cgdp.recog.set.cluster.ClusterSetCondition;
import cgdp.recog.set.gene.GeneSetCondition;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.LabelColorTable;
import cgdp.recog.util.LabelColorTableModel;
import cgdp.recog.util.ListSelectUtil;
import cgdp.recog.util.TabPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SetFilterColorTabPanel
extends TabPanel
implements ActionListener {
    private static final Dimension CANDIDATE_LIST_SIZE = new Dimension(200, 200);
    private static final Dimension TARGET_LIST_SIZE = new Dimension(300, 200);
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private SetCombinationModel setCombinationModel = new SetCombinationModel();
    private FocusTextField nameTextField;
    private JTable candidateTable;
    private LabelColorTable targetTable;
    private JButton addButton;
    private JButton addAndButton;
    private JButton notButton;
    private JButton notAndButton;
    private JButton flipNotButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private SetCombinationControlButtonPanel setCombinationControlButtonPanel;
    private SetFilterColorActionPanel setFilterColorActionPanel;
    private SetConditionGroup setConditionGroup;
    private String preSetConditionName;

    public SetFilterColorTabPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.setFilterColorActionPanel = new SetFilterColorActionPanel();
        this.setFilterColorActionPanel.setBorder(BorderFactory.createTitledBorder("Filter/Color setting"));
        this.setCombinationControlButtonPanel = new SetCombinationControlButtonPanel(this.parent, this.mediator, this.setCombinationModel);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createNamePanel(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 15, 0, 10), 0, 0));
        this.add((Component)this.createListPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.createControlButtonPanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 11, 3, new Insets(10, 0, 0, 10), 0, 0));
        this.add((Component)this.setFilterColorActionPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 15, 10, 15), 0, 0));
        this.add((Component)this.setCombinationControlButtonPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
    }

    private JPanel createNamePanel() {
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createListPanel() {
        this.addButton = new JButton(">>");
        this.addButton.addActionListener(this);
        this.addAndButton = new JButton("&>>");
        this.addAndButton.addActionListener(this);
        this.notButton = new JButton("Not>>");
        this.notButton.addActionListener(this);
        this.notAndButton = new JButton("Not &>>");
        this.notAndButton.addActionListener(this);
        int n = this.notAndButton.getPreferredSize().width;
        int n2 = this.notAndButton.getPreferredSize().height;
        this.addButton.setPreferredSize(new Dimension(n, n2));
        this.addAndButton.setPreferredSize(new Dimension(n, n2));
        this.notButton.setPreferredSize(new Dimension(n, n2));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.addAndButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.notButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.notAndButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel("Set");
        SetNameTableModel setNameTableModel = new SetNameTableModel();
        this.candidateTable = new JTable();
        this.candidateTable.setModel(setNameTableModel);
        this.candidateTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SetFilterColorTabPanel.this.setEnableAddButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.candidateTable, 20, 30);
        jScrollPane.getViewport().setPreferredSize(CANDIDATE_LIST_SIZE);
        JLabel jLabel2 = new JLabel("Condition");
        this.targetTable = new LabelColorTable(){

            protected void processMouseClicked(Object object, int n, int n2) {
                SetFilterColorTabPanel.this.editCondition();
            }
        };
        this.targetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SetFilterColorTabPanel.this.setEnableControlButton();
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.targetTable, 20, 30);
        jScrollPane2.getViewport().setPreferredSize(TARGET_LIST_SIZE);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        jPanel2.add((Component)jScrollPane2, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel2;
    }

    private JPanel createControlButtonPanel() {
        this.flipNotButton = new JButton("Flip Not");
        this.upButton = new JButton("Up");
        this.downButton = new JButton("Down");
        this.deleteButton = new JButton("Delete");
        this.flipNotButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.flipNotButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.upButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.downButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(List list, List list2, SetConditionGroup setConditionGroup, ClusterTbl clusterTbl) {
        this.setConditionGroup = setConditionGroup;
        this.clusterTbl = clusterTbl;
        this.getSetNameTableModel().setDataList(list2);
        this.preSetConditionName = null;
        this.nameTextField.setText(SetConditionUtil.getDefaultName(this.getSetType(), setConditionGroup));
        this.setFilterColorActionPanel.updateValue(1, true);
        this.setCombinationControlButtonPanel.updateValue(clusterTbl);
        List list3 = AbstractElementSetFacade.createDefaultElementSetGroupListForList(list);
        this.setCombinationModel.setElementSetGroupList(list3);
        this.getLabelColorTableModel().setLabelColorList(this.getTargetLabelColorList(list3));
        this.setEnableAddButton();
        this.setEnableControlButton();
        this.initTargetTable();
    }

    public void updateValue(SetCondition setCondition, List list, SetConditionGroup setConditionGroup, ClusterTbl clusterTbl) {
        this.setConditionGroup = setConditionGroup;
        this.clusterTbl = clusterTbl;
        this.setCombinationModel.setElementSetGroupList(setCondition.getElementSetGroupList());
        this.getSetNameTableModel().setDataList(list);
        this.updateValue(setCondition, true, true);
    }

    public void updateValue(SetCondition setCondition, boolean bl, boolean bl2) {
        this.setCombinationModel.setElementSetGroupList(setCondition.getElementSetGroupList());
        this.preSetConditionName = setCondition.getName();
        this.nameTextField.setText(setCondition.getName());
        this.setFilterColorActionPanel.updateValue(SetCondition.getFilterColorAction(bl, bl2), false);
        this.setCombinationControlButtonPanel.updateValue(this.clusterTbl);
        this.getLabelColorTableModel().setLabelColorList(this.getTargetLabelColorListByElementSetGroup(setCondition.getElementSetGroupList()));
        this.setEnableAddButton();
        this.setEnableControlButton();
        this.initTargetTable();
    }

    public int getSetType() {
        List list = this.getSetNameTableModel().getDataList();
        return AbstractElementSetFacade.getSetType(list);
    }

    private List getTargetLabelColorList(List list) {
        ArrayList<ElementSetGroupLabelColor> arrayList = new ArrayList<ElementSetGroupLabelColor>();
        for (ElementSetGroup elementSetGroup : list) {
            ElementSetGroupLabelColor elementSetGroupLabelColor = new ElementSetGroupLabelColor(elementSetGroup);
            elementSetGroupLabelColor.setColor(elementSetGroup.getColor());
            arrayList.add(elementSetGroupLabelColor);
        }
        return arrayList;
    }

    private List getTargetLabelColorListByElementSetGroup(List list) {
        ArrayList<ElementSetGroupLabelColor> arrayList = new ArrayList<ElementSetGroupLabelColor>();
        for (ElementSetGroup elementSetGroup : list) {
            ElementSetGroupLabelColor elementSetGroupLabelColor = new ElementSetGroupLabelColor(elementSetGroup);
            arrayList.add(elementSetGroupLabelColor);
        }
        return arrayList;
    }

    private void initTargetTable() {
        this.targetTable.getColumnModel().getColumn(1).setMinWidth(50);
        this.targetTable.getColumnModel().getColumn(1).setMaxWidth(50);
        this.targetTable.setCellRenderer();
    }

    private LabelColorTableModel getLabelColorTableModel() {
        return (LabelColorTableModel)this.targetTable.getModel();
    }

    private SetNameTableModel getSetNameTableModel() {
        return (SetNameTableModel)this.candidateTable.getModel();
    }

    private void setEnableAddButton() {
        boolean bl = this.candidateTable.getSelectedRow() != -1;
        this.addButton.setEnabled(bl);
        this.addAndButton.setEnabled(bl);
        this.notButton.setEnabled(bl);
        this.notAndButton.setEnabled(bl);
    }

    private void setEnableControlButton() {
        int[] nArray = this.targetTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            this.deleteButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        Arrays.sort(nArray);
        if (nArray[0] == 0) {
            this.upButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
        }
        if (nArray[nArray.length - 1] == this.targetTable.getRowCount() - 1) {
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(true);
        }
        this.deleteButton.setEnabled(true);
    }

    private void add() {
        ListSelectUtil.add((JTable)this.targetTable, this.createLabelColorList(false));
        this.initTargetTable();
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private List createLabelColorList(boolean bl) {
        Object object;
        List list = this.getLabelColorTableModel().getLabelColorList();
        ArrayList arrayList = new ArrayList();
        for (ElementSetGroupLabelColor elementSetGroupLabelColor : list) {
            object = elementSetGroupLabelColor.getElementSetGroup();
            if (((ElementSetGroup)object).getElementSetCount() != 1) continue;
            arrayList.add(((ElementSetGroup)object).getElementSetList().get(0));
        }
        Color[] colorArray = SetColorPatternFactory.createPaintArray();
        int n = this.targetTable.getRowCount();
        object = ListSelectUtil.getSelectedDataList(this.candidateTable);
        ArrayList<ElementSetGroupLabelColor> arrayList2 = new ArrayList<ElementSetGroupLabelColor>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            AbstractElementSet abstractElementSet = (AbstractElementSet)iterator.next();
            if (AbstractElementSetFacade.containsElementSet(arrayList, abstractElementSet)) continue;
            ElementSetGroup elementSetGroup = new ElementSetGroup(abstractElementSet, bl);
            ElementSetGroupLabelColor elementSetGroupLabelColor = new ElementSetGroupLabelColor(elementSetGroup);
            elementSetGroupLabelColor.setColor(colorArray[n % colorArray.length]);
            arrayList2.add(elementSetGroupLabelColor);
            ++n;
        }
        return arrayList2;
    }

    private void addAnd() {
        ListSelectUtil.add((JTable)this.targetTable, (Object)this.createElementSetGroupLabelColor(false));
        this.initTargetTable();
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private ElementSetGroupLabelColor createElementSetGroupLabelColor(boolean bl) {
        List list;
        ElementSetGroup elementSetGroup;
        List list2 = this.getTargetElementSetGroupList();
        if (AbstractElementSetFacade.containsElementSetGroup(list2, elementSetGroup = new ElementSetGroup(list = ListSelectUtil.getSelectedDataList(this.candidateTable), bl))) {
            return null;
        }
        ElementSetGroupLabelColor elementSetGroupLabelColor = new ElementSetGroupLabelColor(elementSetGroup);
        Color[] colorArray = SetColorPatternFactory.createPaintArray();
        int n = this.targetTable.getRowCount();
        elementSetGroupLabelColor.setColor(colorArray[n % colorArray.length]);
        return elementSetGroupLabelColor;
    }

    private void addNot() {
        ListSelectUtil.add((JTable)this.targetTable, this.createLabelColorList(true));
        this.initTargetTable();
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private void addNotAnd() {
        ListSelectUtil.add((JTable)this.targetTable, (Object)this.createElementSetGroupLabelColor(true));
        this.initTargetTable();
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private void flipNot() {
        List list = ListSelectUtil.getSelectedDataList(this.targetTable);
        for (ElementSetGroupLabelColor elementSetGroupLabelColor : list) {
            ElementSetGroup elementSetGroup = elementSetGroupLabelColor.getElementSetGroup();
            elementSetGroup.flipNot();
        }
        this.getLabelColorTableModel().fireTableDataChanged();
        this.initTargetTable();
        ListSelectUtil.select(this.targetTable, list);
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private void delete() {
        ListSelectUtil.remove(this.targetTable);
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private void up() {
        ListSelectUtil.up(this.targetTable);
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private void down() {
        ListSelectUtil.down(this.targetTable);
        this.setCombinationModel.setElementSetGroupList(this.getTargetElementSetGroupList());
    }

    private void editCondition() {
        List list = ListSelectUtil.getSelectedDataList(this.targetTable);
        if (CollectionUtil.isNull(list)) {
            return;
        }
        ElementSetGroupLabelColor elementSetGroupLabelColor = (ElementSetGroupLabelColor)list.get(0);
        ElementSetGroup elementSetGroup = elementSetGroupLabelColor.getElementSetGroup();
        CombinationEditDialog combinationEditDialog = new CombinationEditDialog((Dialog)this.parent);
        combinationEditDialog.updateValue(elementSetGroup);
        combinationEditDialog.setVisible(true);
        if (!combinationEditDialog.isCanceled()) {
            ElementSetGroup elementSetGroup2 = combinationEditDialog.getElementSetGroup();
            if (!elementSetGroup2.isExistElemetSet()) {
                ListSelectUtil.remove(this.targetTable, this.targetTable.getSelectedRow());
            } else {
                elementSetGroupLabelColor.setElementSetGroup(elementSetGroup2);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.addAndButton) {
            this.addAnd();
        } else if (actionEvent.getSource() == this.notButton) {
            this.addNot();
        } else if (actionEvent.getSource() == this.notAndButton) {
            this.addNotAnd();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        } else if (actionEvent.getSource() == this.upButton) {
            this.up();
        } else if (actionEvent.getSource() == this.downButton) {
            this.down();
        } else if (actionEvent.getSource() == this.flipNotButton) {
            this.flipNot();
        }
    }

    private String getConditionName() {
        return this.nameTextField.getText();
    }

    private List getTargetElementSetGroupList() {
        List list = this.getLabelColorTableModel().getLabelColorList();
        ArrayList<ElementSetGroup> arrayList = new ArrayList<ElementSetGroup>();
        for (ElementSetGroupLabelColor elementSetGroupLabelColor : list) {
            ElementSetGroup elementSetGroup = elementSetGroupLabelColor.getElementSetGroup();
            elementSetGroup.setColor(elementSetGroupLabelColor.getColor());
            arrayList.add(elementSetGroup);
        }
        return arrayList;
    }

    private List getTargetElementSetGroupListForVenn() {
        List list = this.setCombinationModel.getElementSetList();
        List list2 = this.getTargetElementSetGroupList();
        return AbstractElementSetFacade.splitElementSetGroupList(list, list2);
    }

    public boolean isAddColor() {
        return this.setFilterColorActionPanel.isAddColor();
    }

    public boolean isAddFilter() {
        return this.setFilterColorActionPanel.isAddFilter();
    }

    protected void changeDefault() {
    }

    public boolean check() {
        SetConditionValidater setConditionValidater = new SetConditionValidater();
        SetConditionValidateCondition setConditionValidateCondition = new SetConditionValidateCondition();
        setConditionValidateCondition.setParent(this);
        setConditionValidateCondition.setName(this.getConditionName());
        setConditionValidateCondition.setPreName(this.preSetConditionName);
        setConditionValidateCondition.setSetConditionGroup(this.setConditionGroup);
        setConditionValidateCondition.setSetType(this.getSetType());
        setConditionValidateCondition.setTargetElementSetGroupList(this.getTargetElementSetGroupList());
        return setConditionValidater.validate(setConditionValidateCondition);
    }

    public SetCondition createSetCondition() {
        List list = this.getTargetElementSetGroupList();
        SetCondition setCondition = SetType.isClusterSet(this.getSetType()) ? new ClusterSetCondition() : new GeneSetCondition();
        setCondition.setSetType(this.getSetType());
        setCondition.setElementSetGroupList(list);
        setCondition.setName(this.getConditionName());
        setCondition.updateElementList();
        return setCondition;
    }

    public SetCondition createSetConditionForVenn() {
        List list = this.getTargetElementSetGroupListForVenn();
        SetCondition setCondition = SetType.isClusterSet(this.getSetType()) ? new ClusterSetCondition() : new GeneSetCondition();
        setCondition.setSetType(this.getSetType());
        setCondition.setElementSetGroupList(list);
        setCondition.setName(this.getConditionName());
        setCondition.updateElementList();
        return setCondition;
    }

    protected void updateParameters() {
    }
}

