/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetDownloader;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.cluster.ClusterSetRegister;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClusterSetDownloadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetDownloadExecuter.class);
    private Component parent;
    private Project project;
    private ClusterTbl clusterTbl;
    private Collection setC;
    private Set unableDeleteSetSet = new HashSet();
    private boolean errorHandling = true;
    private boolean overwriteCheck = false;

    public ClusterSetDownloadExecuter(Component component, Collection collection, ClusterTbl clusterTbl, Project project) {
        this.parent = component;
        this.project = project;
        this.setC = collection;
        this.clusterTbl = clusterTbl;
    }

    public void setErrorHandling(boolean bl) {
        this.errorHandling = bl;
    }

    public void setOverwriteCheck(boolean bl) {
        this.overwriteCheck = bl;
    }

    public Set getUnableDeleteSetSet() {
        return this.unableDeleteSetSet;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.setC.size());
        try {
            Iterator iterator = this.setC.iterator();
            while (iterator.hasNext()) {
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                AbstractElementSet abstractElementSet = (AbstractElementSet)iterator.next();
                ClusterSetDownloader clusterSetDownloader = new ClusterSetDownloader((ClusterSet)abstractElementSet, this.clusterTbl, this.project);
                clusterSetDownloader.execute();
                List list = clusterSetDownloader.getClusterList();
                if (CollectionUtil.isNull(list)) {
                    this.unableDeleteSetSet.add(abstractElementSet);
                    continue;
                }
                abstractElementSet.setElementList(list);
            }
        }
        catch (Exception exception) {
            String string = "Fail to download cluster set.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    public void done() {
        Object object;
        String[] stringArray;
        if (this.isCancel()) {
            return;
        }
        if (this.errorHandling) {
            if (this.isError()) {
                MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
                return;
            }
            if (!CollectionUtil.isNull(this.unableDeleteSetSet)) {
                stringArray = new String[]{"The following set was not able to be downloaded.", AbstractElementSetFacade.createElementSetNameString(this.unableDeleteSetSet)};
                MessageManager.showWarningMessage(this.parent, stringArray);
            }
        }
        stringArray = new ArrayList(this.setC);
        stringArray.removeAll(this.unableDeleteSetSet);
        stringArray = ClusterSetFacade.convertServerToLocalSet(stringArray);
        if (!(CollectionUtil.isNull(stringArray) || this.overwriteCheck && !AbstractElementSetFacade.validateSet(this.parent, (List)stringArray))) {
            object = stringArray.iterator();
            while (object.hasNext()) {
                ClusterSet clusterSet = (ClusterSet)object.next();
                List list = clusterSet.getElementList();
                ClusterSetRegister clusterSetRegister = new ClusterSetRegister(this.parent, clusterSet, list, this.clusterTbl);
                clusterSetRegister.execute(new DummyProgressComponent());
            }
        }
        if ((object = this.getAfterRunnable()) != null) {
            object.run();
        }
    }
}

