/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.project.Project;
import cgdp.recog.set.AbstractSetUploader;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;

public class ClusterSetUploader
extends AbstractSetUploader {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetUploader.class);
    private ClusterSet clusterSet;

    public ClusterSetUploader(ClusterSet clusterSet, String string, Project project) throws Exception {
        super(project);
        this.clusterSet = clusterSet;
        this.setUploadType(string);
        this.setContextPath(URLList.getInstance().getPutClusterSet());
        this.setOptions();
    }

    public void parseOutputString(int n, String string) {
        logger.info(string);
    }

    public void setOptions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode=");
        if (this.uploadType != null) {
            stringBuffer.append(this.uploadType);
        }
        stringBuffer.append("&tabid=");
        stringBuffer.append(this.clusterSet.getDomClustId());
        stringBuffer.append("&set_name=");
        stringBuffer.append(Codec.encode(this.clusterSet.getName()));
        stringBuffer.append("&set_val=");
        stringBuffer.append(Codec.encode(this.getSetContents()));
        this.setOptions(stringBuffer.toString());
    }

    private String getSetContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID");
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (Cluster cluster : this.clusterSet.getElementList()) {
            String string = cluster.getCombinedClusterIdRegardSubCluster();
            stringBuffer.append(string);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        logger.info(stringBuffer.toString());
        return stringBuffer.toString();
    }
}

