/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.color;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetType;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;

public class SetFilerColorItem
extends JMenuItem
implements CommandImpl {
    private static final int TYPE_NEW = 1;
    private static final int TYPE_EDIT = 2;
    private MediatorImpl mediator;
    private int setType;
    private List elementSetList;
    private SetCondition setCondition;
    private int type = 1;

    public SetFilerColorItem(ActionListener actionListener, MediatorImpl mediatorImpl, int n, List list) {
        this.addActionListener(actionListener);
        this.mediator = mediatorImpl;
        this.setType = n;
        this.elementSetList = list;
        this.type = 1;
        this.setText(this.getLabelText());
    }

    public SetFilerColorItem(ActionListener actionListener, MediatorImpl mediatorImpl, SetCondition setCondition) {
        this.addActionListener(actionListener);
        this.mediator = mediatorImpl;
        this.setCondition = setCondition;
        this.type = 2;
        this.setType = setCondition.getSetType();
        this.setText(this.getLabelText());
    }

    private String getLabelText() {
        String string = this.isNew() ? "New " : "Edit ";
        string = SetType.isGeneSet(this.setType) ? string + "gene set combination" : string + "cluster set combination";
        if (this.isEdit()) {
            string = string + " [" + this.setCondition.getDisplayName() + "]";
        }
        string = string + "...";
        return string;
    }

    public void execute() {
        if (this.isNew()) {
            this.mediator.showSetFilterColorDialog(this.setType, this.elementSetList);
        } else if (this.isEdit()) {
            this.mediator.showSetFilterColorDialog(this.setCondition);
        }
    }

    private boolean isNew() {
        return this.type == 1;
    }

    private boolean isEdit() {
        return this.type == 2;
    }
}

