/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.info.AbstractInfo;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.gene.GeneInfoOrganismLocusTagComparator;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GeneSet
extends AbstractElementSet {
    public GeneSet() {
        this.setSetType(1);
        this.newListFilename();
    }

    public GeneSet(String string, String string2, int n) {
        this.setName(string);
        this.setLocation(string2);
        this.setElementSize(n);
        this.setSetType(1);
    }

    public String getFilepath() {
        String string;
        if (this.isGlobalLocation()) {
            string = DataManager.getGlobalGeneSetDirpath() + this.getListFilename();
        } else {
            Project project = ProjectAccesser.getProject(this.getLocation());
            string = DataManager.getProjectGeneSetFilepath(project, this.getListFilename());
        }
        return string;
    }

    public boolean isDuplicateGeneSet(GeneSet geneSet) {
        if (geneSet == null) {
            return false;
        }
        if (geneSet.equalsLocation(this.getLocation()) || LocationType.isNameGlobal(this.getLocation()) && !LocationType.isNameGlobal(geneSet.getLocation()) || !LocationType.isNameGlobal(this.getLocation()) && LocationType.isNameGlobal(geneSet.getLocation())) {
            if (StringTool.isNull(this.getLocation()) || StringTool.isNull(geneSet.getLocation())) {
                return false;
            }
            return geneSet.equalsName(this.getName());
        }
        return false;
    }

    public boolean equalsGeneInfoList(GeneSet geneSet) {
        if (geneSet == null) {
            return false;
        }
        if (CollectionUtil.isNull(geneSet.getElementList()) || CollectionUtil.isNull(this.getElementList())) {
            return false;
        }
        if (geneSet.getElementListSize() != this.getElementListSize()) {
            return false;
        }
        Set set = this.getGeneInfoKeySet(this.getElementList());
        Set set2 = this.getGeneInfoKeySet(geneSet.getElementList());
        return set.equals(set2);
    }

    private Set getGeneInfoKeySet(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (GeneInfo geneInfo : list) {
            String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            String string2 = geneInfo.getLocusTag();
            String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
            hashSet.add(string3);
        }
        return hashSet;
    }

    public void copy(GeneSet geneSet) {
        if (geneSet == null) {
            return;
        }
        this.setName(geneSet.getName());
        this.setLocation(geneSet.getLocation());
        this.setListFilename(geneSet.getListFilename());
        this.setElementList(geneSet.getElementList());
        if (!geneSet.isExistElement()) {
            this.setElementSize(geneSet.getElementSize());
        }
    }

    public boolean contains(Cluster cluster) {
        Set set = cluster.getSpSet();
        for (String string : set) {
            if (!this.contains(cluster, string)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Cluster cluster, String string) {
        List list = cluster.getGeneInformationList(string);
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        for (GeneInformation geneInformation : list) {
            String string2 = geneInformation.getLocusTagWithoutDomain();
            String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
            if (!this.getElementMap().containsKey(string3)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string, String string2) {
        String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
        return this.getElementMap().containsKey(string3);
    }

    public void updateElementList() {
        List list = GeneSetFacade.getInstance().importElementList(this);
        if (list != null) {
            this.setElementList(list);
        }
    }

    protected void updateElementMap() {
        HashMap<String, GeneInfo> hashMap = new HashMap<String, GeneInfo>();
        for (GeneInfo geneInfo : this.getElementList()) {
            String string = GeneUtil.createOrganismLocusTagKey(geneInfo);
            hashMap.put(string, geneInfo);
        }
        this.setElementMap(hashMap);
    }

    public void addElementList(Collection collection) {
        HashSet<GeneInfo> hashSet = new HashSet<GeneInfo>();
        for (GeneInfo geneInfo : collection) {
            String string = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            if (this.contains(string, geneInfo.getLocusTag())) continue;
            hashSet.add(geneInfo);
        }
        ArrayList arrayList = new ArrayList(this.getElementList());
        arrayList.addAll(hashSet);
        Collections.sort(arrayList, new GeneInfoOrganismLocusTagComparator());
        this.setElementList(arrayList);
    }

    public AbstractElementSet intersect(AbstractElementSet abstractElementSet) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        for (GeneInfo geneInfo : abstractElementSet.getElementList()) {
            String string;
            String string2 = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            if (!this.contains(string2, string = geneInfo.getLocusTag())) continue;
            arrayList.add(geneInfo);
        }
        GeneSet geneSet = new GeneSet();
        geneSet.setElementList(arrayList);
        return geneSet;
    }

    public AbstractElementSet subtract(AbstractElementSet abstractElementSet) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : this.getElementList()) {
            String string;
            String string2 = (String)((AbstractInfo)object2).getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
            if (!abstractElementSet.contains(string2, string = ((GeneInfo)object2).getLocusTag())) continue;
            arrayList.add(object2);
        }
        ArrayList arrayList2 = new ArrayList(this.getElementList());
        arrayList2.removeAll(arrayList);
        object2 = new GeneSet();
        ((AbstractElementSet)object2).setElementList(arrayList2);
        return object2;
    }
}

