/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.system.URLList;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class GeneSetDownloader
extends AbstractServerResourceAccesser {
    private static final String DELIMITER = "\t";
    private GeneSet geneSet;
    private List geneInfoList = new ArrayList();

    GeneSetDownloader(GeneSet geneSet, Project project) {
        this.geneSet = geneSet;
        this.setProject(project);
        this.setContextPath(URLList.getInstance().getGetGeneSet());
        this.setOptions();
    }

    public void parseOutputStringData(int n, String string) {
        if (string.startsWith("sp\t")) {
            return;
        }
        Vector vector = StringTool.splitString(string, DELIMITER);
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        GeneInfo geneInfo = new GeneInfo();
        geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string2);
        geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, string3);
        this.geneInfoList.add(geneInfo);
    }

    private void setOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("set_name=" + this.geneSet.getName());
        this.setOptions(stringBuffer.toString());
    }

    public List getGeneInfoList() {
        return this.geneInfoList;
    }
}

