/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.access.FileAccessExecuter;
import cgdp.recog.access.FileAccessExecuterFactory;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.ElementSetComparator;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetConfExporter;
import cgdp.recog.set.gene.GeneSetConfImporter;
import cgdp.recog.set.gene.GeneSetEditDialog;
import cgdp.recog.set.gene.GeneSetIOException;
import cgdp.recog.set.gene.GeneSetImporter;
import cgdp.recog.set.gene.GeneSetListDownloader;
import cgdp.recog.set.gene.GeneSetListExporter;
import cgdp.recog.set.gene.GeneSetListImporter;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MathUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GeneSetFacade
extends AbstractElementSetFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetFacade.class);
    private static final GeneSetFacade GENE_SET_FACADE = new GeneSetFacade();

    private GeneSetFacade() {
    }

    public static GeneSetFacade getInstance() {
        return GENE_SET_FACADE;
    }

    public static List getGeneInfoListFromUserFile(String string) throws IOException {
        GeneSetImporter geneSetImporter = new GeneSetImporter(string);
        geneSetImporter.execute();
        if (geneSetImporter.isError()) {
            throw new GeneSetIOException(geneSetImporter.getErrorMessage());
        }
        return geneSetImporter.getGeneInfoList();
    }

    protected void exportConfFile(List list) throws Exception {
        GeneSetConfExporter geneSetConfExporter = new GeneSetConfExporter(list);
        geneSetConfExporter.execute();
    }

    static void createGeneSetDirectory(String string) {
        String string2;
        if (LocationType.isNameGlobal(string)) {
            string2 = DataManager.getGlobalGeneSetDirpath();
        } else {
            Project project = ProjectAccesser.getProject(string);
            string2 = DataManager.getProjectGeneSetDirpath(project);
        }
        FileUtil.createDirectory(string2);
    }

    public void exportListFile(AbstractElementSet abstractElementSet, List list) throws Exception {
        GeneSetFacade.createGeneSetDirectory(abstractElementSet.getLocation());
        GeneSetListExporter geneSetListExporter = new GeneSetListExporter(abstractElementSet.getFilepath(), list);
        geneSetListExporter.execute();
    }

    public List getElementSetList() {
        try {
            GeneSetConfImporter geneSetConfImporter = new GeneSetConfImporter();
            geneSetConfImporter.execute();
            return geneSetConfImporter.getGeneSetList();
        }
        catch (Exception exception) {
            logger.warn("Fail to load gene set conf file.", exception);
            return new ArrayList();
        }
    }

    public List getGeneSetListGlobalCurrectProject() {
        Project project = ProjectAccesser.getSelectedProject();
        return this.getGeneSetListGlobalAndSameLocation(project.getProjectName());
    }

    public List getGeneSetListGlobalAndSameLocation(String string) {
        List list = this.getElementSetList();
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (GeneSet geneSet : list) {
            if (!geneSet.isGlobalLocation() && !geneSet.equalsLocation(string)) continue;
            arrayList.add(geneSet);
        }
        Collections.sort(arrayList, new ElementSetComparator());
        return arrayList;
    }

    public static void createGeneSet(Frame frame, MediatorImpl mediatorImpl) throws Exception {
        Project project = ProjectAccesser.getSelectedProject();
        FileAccessExecuter fileAccessExecuter = FileAccessExecuterFactory.createGeneSetImportExecuterForProject(frame, mediatorImpl, project.getProjectName());
        fileAccessExecuter.execute();
    }

    public void editGeneSet(MediatorImpl mediatorImpl, GeneSet geneSet) throws Exception {
        Object object;
        if (!geneSet.isExistElement()) {
            object = this.importElementList(geneSet);
            geneSet.setElementList((List)object);
        }
        object = GeneSetEditDialog.getInstance();
        ((GeneSetEditDialog)object).updateValue(geneSet);
        ((Dialog)object).setVisible(true);
        if (((AbstractApplyDialog)object).isCanceled()) {
            return;
        }
        GeneSet geneSet2 = ((GeneSetEditDialog)object).createGeneSet();
        GeneSet geneSet3 = null;
        List list = this.getElementSetList();
        HashSet<GeneSet> hashSet = new HashSet<GeneSet>();
        for (GeneSet geneSet4 : list) {
            if (geneSet4.equalsElement(geneSet)) {
                geneSet3 = geneSet4;
            }
            if (geneSet2.equalsElement(geneSet) || !geneSet4.equalsElement(geneSet2)) continue;
            hashSet.add(geneSet4);
        }
        geneSet3.copy(geneSet2);
        geneSet3.setStatus(geneSet2.getStatus());
        list.removeAll(hashSet);
        this.exportConfFile(list);
        if (geneSet3.isEditList() || geneSet3.isEditLocation()) {
            GeneSetFacade.removeListFile(geneSet);
            this.exportListFile(geneSet3, geneSet3.getElementList());
        }
        GeneSetFacade.removeListFile(hashSet);
        mediatorImpl.updateGeneSetTree();
    }

    public List importElementList(AbstractElementSet abstractElementSet) {
        try {
            GeneSetListImporter geneSetListImporter = new GeneSetListImporter(abstractElementSet.getFilepath());
            geneSetListImporter.execute();
            return geneSetListImporter.getGeneInfoList();
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    protected Set getKeySet(Collection collection) {
        return GeneInfoUtil.createOrganismCodeLocusTagSet(collection);
    }

    protected void updateSetTree(MediatorImpl mediatorImpl) {
        mediatorImpl.updateGeneSetTree();
    }

    public static List eliminateDuplicateElement(List list) {
        LinkedHashMap<String, GeneInfo> linkedHashMap = new LinkedHashMap<String, GeneInfo>();
        for (GeneInfo geneInfo : list) {
            String string = geneInfo.getKey();
            linkedHashMap.put(string, geneInfo);
        }
        return new ArrayList(linkedHashMap.values());
    }

    public static Map createSetBitsInfoMap(List list, Map map) {
        GeneInfoTitle geneInfoTitle = GeneInfoTitle.TITLE_VENN_BIT_PATTERN;
        HashMap<String, GeneInfo> hashMap = new HashMap<String, GeneInfo>();
        for (ElementSetGroup elementSetGroup : map.keySet()) {
            List list2 = (List)map.get(elementSetGroup);
            BitSet bitSet = GeneSetFacade.createBitSet(list, elementSetGroup);
            String string = MathUtil.getBitSetString(list.size(), bitSet);
            for (GeneInfo geneInfo : list2) {
                String string2 = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
                String string3 = geneInfo.getLocusTag();
                String string4 = geneInfo.getKey();
                GeneInfo geneInfo2 = new GeneInfo(string2, string3);
                geneInfo2.putInfo(geneInfoTitle, string);
                hashMap.put(string4, geneInfo2);
            }
        }
        return hashMap;
    }

    public static List downloadGeneSetList(Project project) throws Exception {
        GeneSetListDownloader geneSetListDownloader = new GeneSetListDownloader(project);
        geneSetListDownloader.execute();
        List list = geneSetListDownloader.getGeneSetList();
        List list2 = GeneSetFacade.getElementSetList(1, null);
        for (GeneSet geneSet : list) {
            GeneSet geneSet2 = (GeneSet)GeneSetFacade.getSameElementSet(geneSet, list2);
            if (geneSet2 == null) continue;
            geneSet.setId(geneSet2.getId());
            geneSet.setListFilename(geneSet2.getListFilename());
        }
        return list;
    }

    public static List convertServerToLocalSet(List list, String string) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (GeneSet geneSet : list) {
            GeneSet geneSet2 = new GeneSet();
            geneSet2.copy(geneSet);
            geneSet2.setLocation(string);
            arrayList.add(geneSet2);
        }
        return arrayList;
    }

    public static Map createNameElementSetMap() {
        List list = GeneSetFacade.getInstance().getElementSetList();
        HashMap<String, AbstractElementSet> hashMap = new HashMap<String, AbstractElementSet>();
        for (AbstractElementSet abstractElementSet : list) {
            hashMap.put(abstractElementSet.getName(), abstractElementSet);
        }
        return hashMap;
    }
}

