/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.set.gene.GeneInfoOrganismLocusTagComparator;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GeneSetRegister
implements ProcessImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetRegister.class);
    private static final int LIST_FILE = 1;
    private static final int GENE_INFO_LIST = 2;
    private Component parent;
    private GeneSet geneSet;
    private int type = 1;
    private String filepath;
    private List geneInfoList;

    public GeneSetRegister(Component component, GeneSet geneSet, String string) {
        this.parent = component;
        this.geneSet = geneSet;
        this.filepath = string;
        this.type = 1;
    }

    public GeneSetRegister(Component component, GeneSet geneSet, List list) {
        this.parent = component;
        this.geneSet = geneSet;
        this.geneInfoList = list;
        this.type = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressImpl progressImpl) {
        Object object;
        progressImpl.setTotal(100);
        try {
            GeneSetFacade.createGeneSetDirectory(this.geneSet.getLocation());
            progressImpl.setCount(9);
            progressImpl.increment();
            try {
                List list = this.getGeneInfoList();
                if (this.geneSet.isAddList()) {
                    object = GeneSetFacade.getInstance().importElementList(this.geneSet);
                    this.geneSet.setElementList((List)object);
                    this.geneSet.addElementList(list);
                } else {
                    this.geneSet.setElementList(list);
                }
            }
            catch (IOException iOException) {
                MessageManager.showErrorMessage(this.parent, iOException.getMessage());
                progressImpl.setCount(99);
                progressImpl.increment();
                return;
            }
            progressImpl.setCount(49);
            progressImpl.increment();
            Collections.sort(this.geneSet.getElementList(), new GeneInfoOrganismLocusTagComparator());
            progressImpl.setCount(69);
            progressImpl.increment();
            this.exportGeneSetConf();
            progressImpl.setCount(79);
            progressImpl.increment();
            GeneSetFacade.getInstance().exportListFile(this.geneSet, this.geneSet.getElementList());
            this.geneSet.setNormal();
            progressImpl.setCount(99);
            progressImpl.increment();
        }
        catch (Exception exception) {
            object = "Fail to register gene set file.";
            logger.warn((String)object, exception);
            MessageManager.showErrorMessage(this.parent, (String)object);
        }
        finally {
            progressImpl.setCount(99);
            progressImpl.increment();
        }
    }

    private void exportGeneSetConf() throws Exception {
        List list = GeneSetFacade.getInstance().getElementSetList();
        this.geneSet.margeElementSet(list);
        GeneSetFacade.getInstance().exportConfFile(list);
    }

    private List getGeneInfoList() throws IOException {
        List list = new ArrayList();
        if (this.isListFile()) {
            list = GeneSetFacade.getGeneInfoListFromUserFile(this.filepath);
        } else if (this.isGeneInfoList()) {
            list = this.geneInfoList;
        }
        return list;
    }

    private boolean isListFile() {
        return this.type == 1;
    }

    private boolean isGeneInfoList() {
        return this.type == 2;
    }

    public void done() {
    }
}

