/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.info.gene.GeneDownloadDialog;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.ElementSetComparator;
import cgdp.recog.set.SetDeleteAfterRunnable;
import cgdp.recog.set.SetDeleteRequestExecuter;
import cgdp.recog.set.gene.GeneSetDownloadExecuter;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerGeneSetListDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Gene Set List";
    private MediatorImpl mediator;
    private JTable setTable;
    private JButton deleteButton;

    private ServerGeneSetListDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private ServerGeneSetListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static ServerGeneSetListDialog getInstance(Component component, MediatorImpl mediatorImpl) {
        ServerGeneSetListDialog serverGeneSetListDialog = null;
        if (component instanceof Dialog) {
            serverGeneSetListDialog = new ServerGeneSetListDialog((Dialog)component, mediatorImpl);
        } else if (component instanceof Frame) {
            serverGeneSetListDialog = new ServerGeneSetListDialog((Frame)component, mediatorImpl);
        }
        return serverGeneSetListDialog;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setTable = new JTable(new SetListTableModel());
        this.setTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ServerGeneSetListDialog.this.setEnabledButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.setTable, 20, 30);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setApplyButtonName("Download");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 15, 10, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setEnabledButton();
    }

    private void setEnabledButton() {
        boolean bl = this.setTable.getSelectedRowCount() != 0;
        this.deleteButton.setEnabled(bl);
        this.applyButton.setEnabled(bl);
    }

    public void updateValue(List list) {
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new ElementSetComparator());
        this.getSetListTableModel().setSetList(arrayList);
    }

    private SetListTableModel getSetListTableModel() {
        return (SetListTableModel)this.setTable.getModel();
    }

    public List getSelectedSetList() {
        List list = this.getSetListTableModel().getSetList();
        int[] nArray = this.setTable.getSelectedRows();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        return arrayList;
    }

    private void delete() {
        final List list = this.getSelectedSetList();
        Object[] objectArray = new String[]{"Delete the following sets?", AbstractElementSetFacade.createElementSetNameString(list)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        SetDeleteRequestExecuter setDeleteRequestExecuter = new SetDeleteRequestExecuter(this, list);
        setDeleteRequestExecuter.setAfterRunnable(new SetDeleteAfterRunnable(){

            public void run() {
                HashSet hashSet = new HashSet(list);
                hashSet.removeAll(this.getUnableDeleteSetC());
                ServerGeneSetListDialog.this.getSetListTableModel().removeAll(list);
            }
        });
        new ProgressDialog((Dialog)this, this.mediator, 1, "Delete gene set...", false, (ProcessImpl)setDeleteRequestExecuter);
    }

    protected boolean apply() {
        List list = this.getSelectedSetList();
        GeneDownloadDialog geneDownloadDialog = new GeneDownloadDialog(this);
        Project project = ProjectAccesser.getSelectedProject();
        List list2 = AbstractElementSetFacade.getElementSetNameList(list);
        geneDownloadDialog.updateValue(project.getProjectName(), list2);
        geneDownloadDialog.setVisible(true);
        if (geneDownloadDialog.isCanceled()) {
            return false;
        }
        String string = geneDownloadDialog.getLocationString();
        List list3 = GeneSetFacade.convertServerToLocalSet(list, string);
        if (!AbstractElementSetFacade.validateSet(this, list3)) {
            return false;
        }
        GeneSetDownloadExecuter geneSetDownloadExecuter = new GeneSetDownloadExecuter(this, list3, project);
        geneSetDownloadExecuter.setAfterRunnable(new Runnable(){

            public void run() {
                ServerGeneSetListDialog.this.mediator.updateGeneSetTree();
            }
        });
        new ProgressDialog((Dialog)this, this.mediator, 1, "Download gene set...", false, (ProcessImpl)geneSetDownloadExecuter);
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        }
    }

    private class SetListTableModel
    extends AbstractTableModel {
        private final String[] COLUMN_NAMES = new String[]{"Name", "Count"};
        private List setList = new ArrayList();

        private SetListTableModel() {
        }

        public void setSetList(List list) {
            this.setList = list;
            this.fireTableDataChanged();
        }

        public List getSetList() {
            return this.setList;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getRowCount() {
            return this.setList.size();
        }

        public Object getValueAt(int n, int n2) {
            AbstractElementSet abstractElementSet = (AbstractElementSet)this.setList.get(n);
            if (n2 == 0) {
                return abstractElementSet.getName();
            }
            if (n2 == 1) {
                return new Integer(abstractElementSet.getElementSize());
            }
            return null;
        }

        public void removeAll(Collection collection) {
            this.setList.removeAll(collection);
            this.fireTableDataChanged();
        }
    }
}

