/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.venn;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.set.venn.VennGeneInfoListDialog;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractVennInfoListDialog
extends AbstractApplyDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(VennGeneInfoListDialog.class);
    protected MediatorImpl mediator;
    private JLabel countLabel;
    protected JScrollPane elementListTable;
    private JButton setButton;
    private JButton exportButton;

    protected AbstractVennInfoListDialog(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    protected AbstractVennInfoListDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.setTitle(this.getDialogTitle());
        this.setModal(true);
        this.setResizable(true);
        JLabel jLabel = new JLabel(this.getCountLabel());
        this.countLabel = new JLabel();
        this.elementListTable = this.createInfoListTable();
        this.exportButton = new JButton("Export...");
        this.exportButton.addActionListener(this);
        this.setButton = new JButton(this.getSetButtonLabel());
        this.setButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.setButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.exportButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        jPanel.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.countLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)this.elementListTable, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 15, 0, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected abstract String getDialogTitle();

    protected abstract String getCountLabel();

    protected abstract String getSetButtonLabel();

    protected abstract JScrollPane createInfoListTable();

    protected abstract void updateInfoListTable(List var1);

    public void updateValue(List list) {
        this.updateInfoListTable(list);
        this.countLabel.setText(String.valueOf(list.size()));
        this.pack();
    }

    protected boolean apply() {
        return true;
    }

    protected abstract void createSet();

    protected abstract void export();

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.setButton) {
            this.createSet();
        } else if (actionEvent.getSource() == this.exportButton) {
            this.export();
        }
    }
}

