/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.venn;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.venn.VennCancelItem;
import cgdp.recog.set.venn.VennColorItem;
import cgdp.recog.set.venn.VennContext;
import cgdp.recog.set.venn.VennExportItem;
import cgdp.recog.set.venn.VennFacade;
import cgdp.recog.set.venn.VennInfoListItem;
import cgdp.recog.set.venn.VennModel;
import cgdp.recog.set.venn.VennRenderer;
import cgdp.recog.system.KeyBindUtil;
import cgdp.recog.system.OS;
import cgdp.recog.util.AbstractPrintExecuter;
import cgdp.recog.util.ImageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class VennFigurePanel
extends JPanel
implements MouseListener,
ActionListener {
    private static final String SAVE_COMMAND = "SAVE";
    private static final String PRINT_COMMAND = "PRINT";
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private VennModel vennModel;
    private VennRenderer vennRenderer;

    VennFigurePanel(Component component, MediatorImpl mediatorImpl, VennModel vennModel) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.vennModel = vennModel;
        this.vennRenderer = new VennRenderer(this.vennModel);
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(400, 300));
    }

    public void updateValue(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(VennContext.BACKGROUND_COLOR);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.vennRenderer.setSize(this.getWidth(), this.getHeight());
        if (this.vennModel.isEnableShow()) {
            this.vennRenderer.draw((Graphics2D)graphics);
            this.vennRenderer.drawSelectedArea((Graphics2D)graphics);
        } else {
            this.vennRenderer.drawNoDrawString((Graphics2D)graphics);
        }
    }

    private void showPopup(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Set set = this.vennModel.getSelectedElementSetSetSet();
        VennColorItem vennColorItem = new VennColorItem(this, this.parent, set, this.vennModel);
        jPopupMenu.add(vennColorItem);
        VennCancelItem vennCancelItem = new VennCancelItem(this, this.parent, set, this.vennModel);
        jPopupMenu.add(vennCancelItem);
        VennCancelItem vennCancelItem2 = new VennCancelItem(this, this.parent, this.vennModel);
        jPopupMenu.add(vennCancelItem2);
        jPopupMenu.addSeparator();
        VennInfoListItem vennInfoListItem = new VennInfoListItem(this, this.mediator, this.clusterTbl, this.parent, set, this.vennModel);
        jPopupMenu.add(vennInfoListItem);
        VennExportItem vennExportItem = new VennExportItem(this, this.mediator, this.clusterTbl, this.parent, set, this.vennModel);
        jPopupMenu.add(vennExportItem);
        JMenuItem jMenuItem = new JMenuItem("Save Image...");
        jMenuItem.setActionCommand(SAVE_COMMAND);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Print...");
        jMenuItem2.setActionCommand(PRINT_COMMAND);
        jMenuItem2.addActionListener(this);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.show(this, point.x, point.y);
    }

    private void setSelectedArea(MouseEvent mouseEvent) {
        if (!this.vennModel.containsSelectedArea(mouseEvent.getPoint()) && !KeyBindUtil.isClickForMutliSelect(mouseEvent)) {
            this.vennModel.clearSelectedArea();
        }
        this.vennModel.addSelectedArea(mouseEvent.getPoint());
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.vennModel.isEnableShow()) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            Set set = this.vennModel.getElementSetSet(mouseEvent.getPoint());
            List list = this.vennModel.getElementList(set, this.clusterTbl);
            VennFacade.showInfoListDialog(this.parent, this.mediator, this.clusterTbl, this.vennModel, list);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.vennModel.isEnableShow()) {
            return;
        }
        if (!OS.isWindows()) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent.getPoint());
            }
            if (mouseEvent.getClickCount() == 1) {
                this.setSelectedArea(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.vennModel.isEnableShow()) {
            return;
        }
        if (OS.isWindows()) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent.getPoint());
            }
            if (mouseEvent.getClickCount() == 1) {
                this.setSelectedArea(mouseEvent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        } else if (actionEvent.getActionCommand().equals(SAVE_COMMAND)) {
            ImageUtil.doSaveAsPNG(this.vennRenderer, this.getWidth(), this.getHeight(), this.parent);
        } else if (actionEvent.getActionCommand().equals(PRINT_COMMAND)) {
            AbstractPrintExecuter abstractPrintExecuter = new AbstractPrintExecuter(this.parent, this.getWidth(), this.getHeight()){

                protected void draw(Graphics2D graphics2D, int n, int n2) {
                    graphics2D.setColor(VennContext.BACKGROUND_COLOR);
                    graphics2D.fillRect(0, 0, n, n2);
                    VennFigurePanel.this.vennRenderer.setSize(n, n2);
                    if (VennFigurePanel.this.vennModel.isEnableShow()) {
                        VennFigurePanel.this.vennRenderer.draw(graphics2D);
                    } else {
                        VennFigurePanel.this.vennRenderer.drawNoDrawString(graphics2D);
                    }
                }
            };
            abstractPrintExecuter.execute();
        }
    }
}

