/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.sort.Sortable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSortable
implements Sortable {
    private ProgressImpl progressImpl = new DummyProgressComponent();
    private int inoutType;
    private List resultClusterList;
    private List resultPatternList;

    protected int getInoutType() {
        return this.inoutType;
    }

    public boolean isBaseCluster() {
        return ClusterMode.isBaseCluster(this.getInoutType());
    }

    public boolean isBaseSubCluster() {
        return ClusterMode.isBaseSubCluster(this.getInoutType());
    }

    public void setInoutType(int n) {
        this.inoutType = n;
    }

    public List getResultClusterList() {
        return this.resultClusterList;
    }

    protected void setResultClusterList(List list) {
        this.resultClusterList = list;
    }

    public List getResultPatternList() {
        return this.resultPatternList;
    }

    protected void setResultPatternList(List list) {
        this.resultPatternList = list;
    }

    protected List createResultClusterList(List list) {
        ArrayList arrayList = new ArrayList();
        if (this.isBaseSubCluster()) {
            arrayList.addAll(list);
        } else {
            for (SuperCluster superCluster : list) {
                arrayList.addAll(superCluster.getSubClusterList());
            }
        }
        return arrayList;
    }

    protected List createPatternListForSort(List list) {
        ArrayList<SuperCluster> arrayList = new ArrayList<SuperCluster>();
        HashMap<Integer, SuperCluster> hashMap = new HashMap<Integer, SuperCluster>();
        for (Cluster cluster : list) {
            SuperCluster superCluster = (SuperCluster)hashMap.get(new Integer(cluster.getClusterId()));
            if (superCluster == null) {
                superCluster = new SuperCluster();
                hashMap.put(new Integer(cluster.getClusterId()), superCluster);
                arrayList.add(superCluster);
            }
            superCluster.addSubCluster(cluster);
        }
        return arrayList;
    }

    protected List createPatternList(List list) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        for (Cluster cluster : list) {
            Map map = cluster.getPatternMap();
            if (arrayList.contains(map)) continue;
            arrayList.add(map);
        }
        return arrayList;
    }

    public void setProgressImpl(ProgressImpl progressImpl) {
        this.progressImpl = progressImpl;
    }

    protected ProgressImpl getProgressImpl() {
        return this.progressImpl;
    }

    protected boolean isCanceled() {
        return this.progressImpl != null && this.progressImpl.isCanceled();
    }

    protected void incrementProgress() {
        if (this.progressImpl != null) {
            this.progressImpl.increment();
        }
    }
}

