/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.sort;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.organism.OrganismComboBox;
import cgdp.recog.sort.GeneInfoSortCondition;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import cgdp.recog.sort.SortOrder;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class GeneInfoSortDialog
extends AbstractApplyDialog
implements ItemListener {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoSortDialog.class);
    private static GeneInfoSortDialog GENE_INFO_SORT_DIALOG;
    private static final String TITLE = "Sort by gene/cluster/cell properties";
    private static final int DEFAULT_CONDITION_COUNT = 3;
    private static final String NO_SORT_KEY = "#NONE#";
    private static final AbstractInfoTitle NO_SORT;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private List sortKeyList;
    private OrganismComboBox organismComboBox;
    private List sortConditionComponentList = new ArrayList();
    private JButton addConditionButton;

    private GeneInfoSortDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static void createInstance(Frame frame, MediatorImpl mediatorImpl) {
        GENE_INFO_SORT_DIALOG = new GeneInfoSortDialog(frame, mediatorImpl);
    }

    public static GeneInfoSortDialog getInstance() {
        GENE_INFO_SORT_DIALOG.removeNoSetCondition();
        GENE_INFO_SORT_DIALOG.updateComponents();
        return GENE_INFO_SORT_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.organismComboBox = new OrganismComboBox();
        this.organismComboBox.addItemListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.organismComboBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 5, 10), 0, 0));
        for (int i = 0; i < 3; ++i) {
            SortConditionComponent sortConditionComponent = new SortConditionComponent();
            this.sortConditionComponentList.add(sortConditionComponent);
            this.getContentPane().add((Component)sortConditionComponent, new GridBagConstraints(0, i + 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        }
        this.addConditionButton = new JButton("Add Condition");
        this.addConditionButton.addActionListener(this);
        this.getContentPane().add((Component)this.addConditionButton, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.updateSortKeyItems();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(String string, List list, ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        if (!StringTool.isNull(string)) {
            this.organismComboBox.removeItemListener(this);
            this.organismComboBox.updateValueByOrganismCode(list);
            this.organismComboBox.setSelectedOrganismCode(string);
            this.organismComboBox.addItemListener(this);
        }
        this.updateSortKeyItems();
    }

    private void removeNoSetCondition() {
        ArrayList<SortConditionComponent> arrayList = new ArrayList<SortConditionComponent>();
        for (SortConditionComponent sortConditionComponent : this.sortConditionComponentList) {
            if (sortConditionComponent.isSetCondition()) continue;
            arrayList.add(sortConditionComponent);
        }
        while (this.sortConditionComponentList.size() - arrayList.size() < 3) {
            arrayList.remove(0);
        }
        this.sortConditionComponentList.removeAll(arrayList);
    }

    private List getSortKeyList(String string) {
        ArrayList<AbstractInfoTitle> arrayList = new ArrayList<AbstractInfoTitle>();
        arrayList.add(NO_SORT);
        arrayList.addAll(GeneInfoFacade.createSelectableGeneInfoTitleList(string));
        arrayList.addAll(ClusterInfoFacade.getInfoTitleListByAnalysisKey("UseSort", this.clusterTbl));
        arrayList.addAll(CellInfoFacade.getInfoTitleListByAnalysisKey("UseSort", this.clusterTbl));
        return arrayList;
    }

    protected boolean check() {
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = this.createGeneInfoSortConditionGroup();
        if (!geneInfoSortConditionGroup.isExistCondition()) {
            MessageManager.showErrorMessage((Component)this, "Input condition.");
            return false;
        }
        return true;
    }

    protected boolean apply() {
        return true;
    }

    public GeneInfoSortConditionGroup createGeneInfoSortConditionGroup() {
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = new GeneInfoSortConditionGroup();
        geneInfoSortConditionGroup.setSortName("Gene properties");
        geneInfoSortConditionGroup.setInoutType(ClusterMode.getClusterMode());
        geneInfoSortConditionGroup.setOrganismCode(this.organismComboBox.getSelectedOrganismCode());
        geneInfoSortConditionGroup.setClusterInfoCalcCondition(ClusterInfoFacade.createClusterInfoCalcCondition(this.clusterTbl));
        for (SortConditionComponent sortConditionComponent : this.sortConditionComponentList) {
            if (!sortConditionComponent.isSetCondition()) continue;
            geneInfoSortConditionGroup.addCondition(sortConditionComponent.createGeneInfoSortCondition());
        }
        return geneInfoSortConditionGroup;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.addConditionButton) {
            SortConditionComponent sortConditionComponent = new SortConditionComponent();
            sortConditionComponent.updateSortKeyItem(this.sortKeyList);
            this.sortConditionComponentList.add(sortConditionComponent);
            this.updateComponents();
        }
    }

    private void updateComponents() {
        int n;
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.organismComboBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 5, 10), 0, 0));
        for (n = 0; n < this.sortConditionComponentList.size(); ++n) {
            SortConditionComponent sortConditionComponent = (SortConditionComponent)this.sortConditionComponentList.get(n);
            this.getContentPane().add((Component)sortConditionComponent, new GridBagConstraints(0, n + 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        }
        n = this.sortConditionComponentList.size();
        this.getContentPane().add((Component)this.addConditionButton, new GridBagConstraints(0, n + 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(1, n + 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().validate();
        this.pack();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.organismComboBox) {
            this.updateSortKeyItems();
        }
    }

    private void updateSortKeyItems() {
        String string = this.organismComboBox.getSelectedOrganismCode();
        this.sortKeyList = this.getSortKeyList(string);
        for (SortConditionComponent sortConditionComponent : this.sortConditionComponentList) {
            sortConditionComponent.updateSortKeyItem(this.sortKeyList);
        }
    }

    static {
        NO_SORT = new GeneInfoTitle(NO_SORT_KEY, "", -1);
    }

    private class SortConditionComponent
    extends JPanel {
        private JComboBox orderComboBox;
        private InfoTitleComboBox keyComboBox;

        public SortConditionComponent() {
            this.init();
        }

        private void init() {
            this.keyComboBox = new InfoTitleComboBox();
            this.keyComboBox.setSelectedItem(GeneInfoSortDialog.NO_SORT_KEY);
            this.orderComboBox = new JComboBox<String>(this.createOrderItems());
            this.setLayout(new GridBagLayout());
            this.add((Component)this.orderComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.keyComboBox, new GridBagConstraints(1, 0, 1, 1, 3.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        private String[] createOrderItems() {
            String[] stringArray = new String[]{"Asc", "Desc"};
            return stringArray;
        }

        public void updateSortKeyItem(List list) {
            this.keyComboBox.updateInfoTitleItems(list);
        }

        private AbstractInfoTitle getKey() {
            return this.keyComboBox.getSelectedInfoTitle();
        }

        private int getOrder() {
            String string = (String)this.orderComboBox.getSelectedItem();
            return SortOrder.name2Type(string);
        }

        public boolean isSetCondition() {
            return !this.getKey().equalsKey(GeneInfoSortDialog.NO_SORT_KEY);
        }

        private GeneInfoSortCondition createGeneInfoSortCondition() {
            GeneInfoSortCondition geneInfoSortCondition = new GeneInfoSortCondition();
            geneInfoSortCondition.setInfoTitle(this.getKey());
            geneInfoSortCondition.setOrder(this.getOrder());
            geneInfoSortCondition.setMultiElementType(this.getKey().getMultiElementType());
            geneInfoSortCondition.setMultiInfoType(this.getKey().getMultiInfoType());
            return geneInfoSortCondition;
        }
    }
}

