/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.data.InnerTbl;
import cgdp.recog.data.OuterTbl;
import cgdp.recog.data.PublicSpecTbl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.taxonomy.TaxonomyIconSetter;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TaxonomyTreeCellRenderer
extends DefaultTreeCellRenderer {
    private OuterTbl outerTbl;
    private InnerTbl innerTbl;
    private PublicSpecTbl publicSpecTbl;
    private String publicColor;
    private TaxonomyIconSetter taxonomyIconSetter = new TaxonomyIconSetter(this);

    public TaxonomyTreeCellRenderer() {
        this.outerTbl = OuterTbl.getInstance();
        this.innerTbl = InnerTbl.getInstance();
        this.publicSpecTbl = PublicSpecTbl.getInstance();
        this.publicColor = OptionTbl.getInstance().getOptionValues().getPublicColor();
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (!(object instanceof TaxonomyTreeNode)) {
            return this;
        }
        this.selected = bl;
        this.hasFocus = bl4;
        TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)object;
        String string = jTree.convertValueToText(taxonomyTreeNode, bl, bl2, bl3, n, bl4);
        String string2 = taxonomyTreeNode.getAbbreviation();
        if (this.publicSpecTbl.containsKey(string2)) {
            string = "<html><font color=" + this.publicColor + ">" + string + "</font></html>";
        }
        this.setText(string);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.taxonomyIconSetter.setTreeNodeIcon(jTree, bl3, bl2, this.innerTbl.containsKey(string2), this.outerTbl.containsKey(string2), string2);
        this.setComponentOrientation(jTree.getComponentOrientation());
        return this;
    }
}

