/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.FilterFacade;
import cgdp.recog.taxonomy.TaxonomyIconSetter;
import cgdp.recog.taxonomy.TaxonomyTree;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TaxonomyTreeExCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color SP_NODE_COLOR_ALL = new Color(255, 128, 128);
    private static final Color SP_NODE_COLOR_ANY = new Color(128, 128, 255);
    private static final Color SP_NODE_COLOR_NONE = new Color(192, 192, 192);
    private TaxonomyIconSetter taxonomyIconSetter = new TaxonomyIconSetter(this);

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (!(object instanceof TaxonomyTreeNode)) {
            return this;
        }
        this.selected = bl;
        this.hasFocus = bl4;
        TaxonomyTreeNode taxonomyTreeNode = (TaxonomyTreeNode)object;
        String string = jTree.convertValueToText(taxonomyTreeNode, bl, bl2, bl3, n, bl4);
        this.setText(string);
        ClusterTbl clusterTbl = ((TaxonomyTree)jTree).getClusterTbl();
        this.setForeground(this.getNodeForgroundColor(taxonomyTreeNode, bl));
        String string2 = taxonomyTreeNode.getAbbreviation();
        boolean bl5 = false;
        boolean bl6 = false;
        if (clusterTbl != null) {
            bl5 = clusterTbl.isIngroup(string2);
            bl6 = clusterTbl.isOutgroup(string2);
        }
        this.taxonomyIconSetter.setTreeNodeIcon(jTree, bl3, bl2, bl5, bl6, string2);
        this.setComponentOrientation(jTree.getComponentOrientation());
        return this;
    }

    private Color getNodeForgroundColor(TaxonomyTreeNode taxonomyTreeNode, boolean bl) {
        FilterFacade filterFacade;
        Color color = null;
        color = taxonomyTreeNode.isLeaf() ? ((filterFacade = FilterFacade.getInstance()).isAll(taxonomyTreeNode.getAbbreviation()) ? SP_NODE_COLOR_ALL : (filterFacade.isNone(taxonomyTreeNode.getAbbreviation()) ? SP_NODE_COLOR_NONE : (filterFacade.isAny(taxonomyTreeNode.getAbbreviation()) ? SP_NODE_COLOR_ANY : (bl ? this.getTextSelectionColor() : this.getTextNonSelectionColor())))) : (bl ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
        return color;
    }
}

