/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.data.RankDif;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.taxonomy.map.RankChangeEvent;
import cgdp.recog.taxonomy.map.TaxMapModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class TaxMapDisplayRankModeMenu
extends JMenu
implements MenuListener,
ActionListener {
    private static Set excludeRankSet = new HashSet();
    private TaxMapModel taxMapModel;

    TaxMapDisplayRankModeMenu() {
        this.createComponents();
    }

    TaxMapDisplayRankModeMenu(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
        this.createComponents();
    }

    private void createComponents() {
        this.setText("Display Rank");
        this.addMenuListener(this);
    }

    public void setTaxMapModel(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    private void createSubMenuList() {
        this.setText("Display Rank");
        ButtonGroup buttonGroup = new ButtonGroup();
        DisplayRankMenuItem displayRankMenuItem = new DisplayRankMenuItem(this, this.taxMapModel, "Select Rank On Taxonomy Tree", "SelectRank");
        buttonGroup.add(displayRankMenuItem);
        this.add(displayRankMenuItem);
        displayRankMenuItem.setSelected(this.taxMapModel.isSameDisplayRankMode("SelectRank"));
        this.addSeparator();
        for (int i = 0; i < RankDif.RANKS.length; ++i) {
            if (excludeRankSet.contains(RankDif.RANKS[i]) || !this.taxMapModel.containsShowRank(RankDif.RANKS[i])) continue;
            displayRankMenuItem = new DisplayRankMenuItem(this, this.taxMapModel, RankDif.RANKS[i], RankDif.RANKS[i]);
            buttonGroup.add(displayRankMenuItem);
            this.add(displayRankMenuItem);
            displayRankMenuItem.setSelected(this.taxMapModel.isSameDisplayRankMode(RankDif.RANKS[i]));
        }
        displayRankMenuItem = new DisplayRankMenuItem(this, this.taxMapModel, "genome", "genome");
        buttonGroup.add(displayRankMenuItem);
        this.add(displayRankMenuItem);
        displayRankMenuItem.setSelected(this.taxMapModel.isSameDisplayRankMode("genome"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        this.removeAll();
        this.createSubMenuList();
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    static {
        excludeRankSet.add("top level");
        excludeRankSet.add("no rank");
    }

    private class DisplayRankMenuItem
    extends JRadioButtonMenuItem
    implements CommandImpl {
        private TaxMapModel taxMapModel;
        private String rank;

        DisplayRankMenuItem(ActionListener actionListener, TaxMapModel taxMapModel, String string, String string2) {
            super(string);
            this.taxMapModel = taxMapModel;
            this.rank = string2;
            this.addActionListener(actionListener);
        }

        public void execute() {
            this.taxMapModel.setDisplayRankMode(this.rank);
            RankChangeEvent rankChangeEvent = new RankChangeEvent(this);
            this.taxMapModel.nodifyObservers(rankChangeEvent);
        }
    }
}

