/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.taxonomy.map.AbstractTaxMapGraphCreater;
import cgdp.recog.taxonomy.map.RankChangeEvent;
import cgdp.recog.taxonomy.map.TaxMapDisplayRankModeMenu;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapGraphCreater;
import cgdp.recog.taxonomy.map.TaxMapGraphDataExportItem;
import cgdp.recog.taxonomy.map.TaxMapGraphHelper;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapPropertyGraphOrientationItem;
import cgdp.recog.taxonomy.map.TaxMapShowGraphDataListItem;
import cgdp.recog.taxonomy.map.TaxMapShowHigherRankItem;
import cgdp.recog.taxonomy.map.TaxMapShowUnassignedGeneItem;
import cgdp.recog.taxonomy.map.TaxMapViewDialog;
import cgdp.recog.taxonomy.map.TaxMapViewHandler;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.data.general.Dataset;

class TaxMapGraphPanel
extends JPanel
implements ActionListener,
ItemListener,
ApplicationObserver,
ChartMouseListener,
TaxMapViewHandler,
MouseListener {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapGraphPanel.class);
    private static final String VIEW_COMMAND = "VIEW";
    private static final String TITLE = "Property Graph";
    private static final Set REMOVE_TITLE_KEY_SET = new HashSet();
    private Frame parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private TaxMapModel taxMapModel;
    private JLabel titleLabel;
    private InfoTitleComboBox infoTitleComboBox;
    private ChartPanel chartPanel;
    private TaxMapGraphCreater taxMapGraphCreater;
    private boolean showView = true;
    private TaxMapViewDialog view;
    private TaxMapDisplayRankModeMenu taxMapDisplayRankModeMenu;
    private TaxMapGraphDataExportItem taxMapGraphDataExportItem;
    private TaxMapShowUnassignedGeneItem showUnassignedItem;
    private TaxMapShowHigherRankItem showHigherRankItem;
    private TaxMapPropertyGraphOrientationItem taxMapPropertyGraphOrientationItem;
    private TaxMapShowGraphDataListItem taxMapShowGraphDataListItem;

    TaxMapGraphPanel(Frame frame, MediatorImpl mediatorImpl, TaxMapModel taxMapModel) {
        this(frame, mediatorImpl, taxMapModel, true);
    }

    private TaxMapGraphPanel(Frame frame, MediatorImpl mediatorImpl, TaxMapModel taxMapModel, boolean bl) {
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.taxMapModel = taxMapModel;
        this.showView = bl;
        this.createComponents();
    }

    private void createComponents() {
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(TaxMapModel.TITLE_FONT);
        this.infoTitleComboBox = new InfoTitleComboBox();
        this.infoTitleComboBox.addItemListener(this);
        this.chartPanel = new ChartPanel(null);
        this.chartPanel.addChartMouseListener(this);
        this.chartPanel.setPreferredSize(new Dimension(400, 170));
        this.chartPanel.addMouseListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.infoTitleComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.chartPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPopupMenu createPopupMenu(ChartPanel chartPanel) {
        JPopupMenu jPopupMenu = new JPopupMenu("Chart:");
        this.showUnassignedItem = new TaxMapShowUnassignedGeneItem(this);
        this.showUnassignedItem.setSelected(true);
        jPopupMenu.add(this.showUnassignedItem);
        this.showHigherRankItem = new TaxMapShowHigherRankItem(this);
        this.showHigherRankItem.setSelected(true);
        jPopupMenu.add(this.showHigherRankItem);
        this.taxMapDisplayRankModeMenu = new TaxMapDisplayRankModeMenu();
        jPopupMenu.add(this.taxMapDisplayRankModeMenu);
        jPopupMenu.addSeparator();
        this.taxMapPropertyGraphOrientationItem = new TaxMapPropertyGraphOrientationItem(this);
        jPopupMenu.add(this.taxMapPropertyGraphOrientationItem);
        jPopupMenu.addSeparator();
        this.taxMapShowGraphDataListItem = new TaxMapShowGraphDataListItem(this, this.clusterTbl, this.taxMapModel, this.createDataset(), "Property graph data list");
        jPopupMenu.add(this.taxMapShowGraphDataListItem);
        jPopupMenu.addSeparator();
        this.taxMapGraphDataExportItem = new TaxMapGraphDataExportItem(this, this.parent, this.taxMapModel, this.clusterTbl, this.getInfoTitle());
        jPopupMenu.add(this.taxMapGraphDataExportItem);
        JMenuItem jMenuItem = new JMenuItem("Save Image...");
        jMenuItem.setActionCommand("SAVE");
        jMenuItem.addActionListener(chartPanel);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Print...");
        jMenuItem2.setActionCommand("PRINT");
        jMenuItem2.addActionListener(chartPanel);
        jPopupMenu.add(jMenuItem2);
        if (this.isShowView()) {
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem3 = new JMenuItem("Show in another window");
            jMenuItem3.setActionCommand(VIEW_COMMAND);
            jMenuItem3.addActionListener(this);
            jPopupMenu.add(jMenuItem3);
        }
        return jPopupMenu;
    }

    private Dataset createDataset() {
        try {
            Dataset dataset = TaxMapFacade.createPropertyGraphDataset(this.clusterTbl, this.taxMapModel);
            return dataset;
        }
        catch (Exception exception) {
            logger.warn("Fail to create dataset.", exception);
            return null;
        }
    }

    private AbstractInfoTitle getInfoTitle() {
        return this.infoTitleComboBox.getSelectedInfoTitle();
    }

    public void updateValue() {
        this.titleLabel.setText(this.taxMapModel.getGraphTitle());
        this.updateInfoTitleComboBox();
        this.updateGraph();
        this.chartPanel.setPopupMenu(this.createPopupMenu(this.chartPanel));
        this.taxMapDisplayRankModeMenu.setTaxMapModel(this.taxMapModel);
        this.showUnassignedItem.setTaxMapModel(this.taxMapModel);
        this.showHigherRankItem.setTaxMapModel(this.taxMapModel);
        this.taxMapPropertyGraphOrientationItem.setTaxMapModel(this.taxMapModel);
        this.showUnassignedItem.setSelected(this.taxMapModel.isShowUnassigned());
        this.showHigherRankItem.setSelected(this.taxMapModel.isShowHigherRank());
    }

    private void updateGraph() {
        this.taxMapGraphCreater = AbstractTaxMapGraphCreater.createTaxMapGraphCreater(this.getInfoTitle(), this.taxMapModel, this.clusterTbl);
        this.chartPanel.setChart(this.taxMapGraphCreater.createChart());
    }

    private void updateInfoTitleComboBox() {
        List list = GeneInfoFacade.getGeneInfoTitleList(this.taxMapModel.getMappingOrganismCodeSet());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AbstractInfoTitle abstractInfoTitle : list) {
            if (REMOVE_TITLE_KEY_SET.contains(abstractInfoTitle.getKey())) continue;
            arrayList.add(abstractInfoTitle);
        }
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle("CFuncCat");
        arrayList.add(0, clusterInfoTitle);
        this.infoTitleComboBox.removeItemListener(this);
        this.infoTitleComboBox.updateInfoTitleItems(arrayList);
        this.infoTitleComboBox.setSelectedItem(this.taxMapModel.getSelectedInfoTitle().getName());
        this.infoTitleComboBox.addItemListener(this);
    }

    void setTaxMapModel(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
    }

    void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
    }

    public TaxMapViewDialog createView() {
        TaxMapGraphPanel taxMapGraphPanel = new TaxMapGraphPanel(this.parent, this.mediator, this.taxMapModel, false);
        taxMapGraphPanel.setClusterTbl(this.clusterTbl);
        taxMapGraphPanel.updateValue();
        taxMapGraphPanel.setPreferredSize(new Dimension(600, 400));
        TaxMapViewDialog taxMapViewDialog = new TaxMapViewDialog(this.parent, TITLE, taxMapGraphPanel, this.taxMapModel, this);
        taxMapViewDialog.setVisible(true);
        return taxMapViewDialog;
    }

    public void disposeView() {
        if (this.view == null) {
            return;
        }
        this.view.dispose();
        this.view.setVisible(false);
        this.view = null;
    }

    public TaxMapViewDialog getView() {
        return this.view;
    }

    public boolean isShowView() {
        return this.showView;
    }

    public void setView(TaxMapViewDialog taxMapViewDialog) {
        this.view = taxMapViewDialog;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        } else if (actionEvent.getActionCommand().equals(VIEW_COMMAND)) {
            TaxMapViewDialog taxMapViewDialog = this.getView();
            if (taxMapViewDialog == null) {
                this.setView(this.createView());
                taxMapViewDialog = this.getView();
            }
            taxMapViewDialog.setVisible(true);
        }
    }

    public void update(Observable observable, Object object) {
        ApplicationObserverEvent applicationObserverEvent = (ApplicationObserverEvent)object;
        if (applicationObserverEvent.getSource() == this) {
            return;
        }
        if (applicationObserverEvent instanceof RankChangeEvent) {
            if (this.taxMapModel.isOtherSelected()) {
                return;
            }
            this.updateValue();
            this.repaint();
        }
    }

    public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
        if (chartMouseEvent.getTrigger().isPopupTrigger()) {
            this.createPopupMenu(this.chartPanel);
        }
        if (!(chartMouseEvent.getEntity() instanceof CategoryItemEntity)) {
            return;
        }
        CategoryItemEntity categoryItemEntity = (CategoryItemEntity)chartMouseEvent.getEntity();
        String string = (String)((Object)categoryItemEntity.getColumnKey());
        string = this.taxMapModel.getOrganismCodeByName(string);
        TaxMapGraphHelper taxMapGraphHelper = new TaxMapGraphHelper(this, this.mediator);
        taxMapGraphHelper.setTaxMapModel(this.taxMapModel);
        taxMapGraphHelper.clickRankName(string);
    }

    public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.infoTitleComboBox) {
            this.taxMapModel.setSelectedInfoTitle(this.infoTitleComboBox.getSelectedInfoTitle());
            this.updateGraph();
            this.taxMapShowGraphDataListItem.setDataset(this.createDataset());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.taxMapGraphDataExportItem.updateValue(this.taxMapModel, this.clusterTbl, this.getInfoTitle());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        REMOVE_TITLE_KEY_SET.add("locustag");
        REMOVE_TITLE_KEY_SET.add("sp");
        REMOVE_TITLE_KEY_SET.add("name");
        REMOVE_TITLE_KEY_SET.add("geneid");
        REMOVE_TITLE_KEY_SET.add("gene");
        REMOVE_TITLE_KEY_SET.add("gi");
        REMOVE_TITLE_KEY_SET.add("protid");
        REMOVE_TITLE_KEY_SET.add("chrid");
        REMOVE_TITLE_KEY_SET.add("chromosome");
        REMOVE_TITLE_KEY_SET.add("type");
    }
}

