/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.taxonomy.RankCheckBoxPanel;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxTreeChangeEvent;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TaxMapOptionDialog
extends AbstractApplyDialog
implements ChangeListener,
ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapOptionDialog.class);
    private static TaxMapOptionDialog TAXMAP_OPTION_DIALOG;
    private static String TITLE;
    private RankCheckBoxPanel rankCheckBoxPanel;
    private RestrictTextField maxCountValueField;
    private RestrictTextField cumulativeBarStepTextField;
    private JSlider cumulativeBarStepSlider;
    private JCheckBox cumulativeCheckBox;
    private TaxMapModel taxMapModel;

    private TaxMapOptionDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    static void createInstance(Frame frame) {
        TAXMAP_OPTION_DIALOG = new TaxMapOptionDialog(frame);
    }

    static TaxMapOptionDialog getInstance() {
        return TAXMAP_OPTION_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.rankCheckBoxPanel = new RankCheckBoxPanel();
        this.rankCheckBoxPanel.setBorder(BorderFactory.createTitledBorder("Display Rank"));
        JPanel jPanel = this.createPropertyGraphOptionPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Property Graph"));
        JPanel jPanel2 = this.createTaxonomyTreeOptionPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Taxonomy Tree"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.rankCheckBoxPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 15, 10, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createPropertyGraphOptionPanel() {
        JLabel jLabel = new JLabel("Display top # properties");
        this.maxCountValueField = new RestrictTextField(3);
        this.maxCountValueField.setRestrict(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
        jPanel.add((Component)this.maxCountValueField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        return jPanel;
    }

    private JPanel createTaxonomyTreeOptionPanel() {
        JLabel jLabel = new JLabel("Step width of a cumulative bar (%)");
        this.cumulativeBarStepTextField = new RestrictTextField(4);
        this.cumulativeBarStepTextField.setRestrict(4);
        this.cumulativeBarStepTextField.addActionListener(this);
        this.cumulativeBarStepSlider = new JSlider(0, 100);
        this.cumulativeBarStepSlider.setPaintTicks(true);
        this.cumulativeBarStepSlider.setMajorTickSpacing(20);
        this.cumulativeBarStepSlider.setMinorTickSpacing(0);
        this.cumulativeBarStepSlider.addChangeListener(this);
        Hashtable<Integer, JComponent> hashtable = this.cumulativeBarStepSlider.createStandardLabels(20, 0);
        this.cumulativeBarStepSlider.setLabelTable(hashtable);
        this.cumulativeBarStepSlider.setPaintLabels(true);
        this.cumulativeCheckBox = new JCheckBox();
        this.cumulativeCheckBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
        jPanel.add((Component)this.cumulativeBarStepTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.cumulativeBarStepSlider, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.cumulativeCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        return jPanel;
    }

    public void updateValue(TaxMapModel taxMapModel) {
        this.taxMapModel = taxMapModel;
        this.rankCheckBoxPanel.updateValue(taxMapModel.isAllRank(), taxMapModel.getRankSet());
        this.maxCountValueField.setText(String.valueOf(this.taxMapModel.getDisplayMaxValuePropGraph()));
        this.cumulativeBarStepTextField.setText(String.valueOf(this.taxMapModel.getCumulativeBarStep()));
        this.cumulativeBarStepSlider.setValue((int)this.taxMapModel.getCumulativeBarStep());
        this.cumulativeCheckBox.setSelected(this.taxMapModel.isCumulative());
        this.cumulativeBarStepTextField.setEnabled(this.taxMapModel.isCumulative());
        this.cumulativeBarStepSlider.setEnabled(this.taxMapModel.isCumulative());
    }

    private void updateTaxMapModel() {
        this.taxMapModel.setAllRank(this.isAllRank());
        this.taxMapModel.setRankSet(this.getShowRankSet());
        this.taxMapModel.setDisplayMaxValuePropGraph(this.getMaxCountValue());
        this.taxMapModel.setCumulativeBarStep(this.getCumulativeBarStepValue());
        this.taxMapModel.setTreeBarType(this.getTaxTreeBarType());
        TaxTreeChangeEvent taxTreeChangeEvent = new TaxTreeChangeEvent(this);
        this.taxMapModel.nodifyObservers(taxTreeChangeEvent);
        try {
            ApplicationPropertyFacade.saveProperty(this.taxMapModel.getDomClustId(), this.taxMapModel);
        }
        catch (IOException iOException) {
            String string = "Fail to save the taxonomy mapping option.";
            logger.warn(string, iOException);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }

    protected boolean check() {
        try {
            this.getMaxCountValue();
        }
        catch (NumberFormatException numberFormatException) {
            MessageManager.showErrorMessage((Component)this, "Input [Display top # properties]");
            return false;
        }
        return true;
    }

    protected boolean apply() {
        this.updateTaxMapModel();
        return true;
    }

    private boolean isAllRank() {
        return this.rankCheckBoxPanel.isAllRank();
    }

    private Set getShowRankSet() {
        return this.rankCheckBoxPanel.getSelectedRankSet();
    }

    public int getMaxCountValue() {
        return Integer.parseInt(this.maxCountValueField.getText());
    }

    public double getCumulativeBarStepValue() {
        int n = this.cumulativeBarStepSlider.getValue();
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.cumulativeBarStepSlider) {
            this.cumulativeBarStepTextField.setText(String.valueOf(this.getCumulativeBarStepValue()));
        }
    }

    public boolean isCumulative() {
        return this.cumulativeCheckBox.isSelected();
    }

    public int getTaxTreeBarType() {
        boolean bl = this.cumulativeCheckBox.isSelected();
        if (bl) {
            return 3;
        }
        return 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cumulativeBarStepTextField) {
            this.cumulativeBarStepSlider.setValue(Integer.parseInt(this.cumulativeBarStepTextField.getText()));
        } else if (actionEvent.getSource() == this.cumulativeCheckBox) {
            this.cumulativeBarStepTextField.setEnabled(this.cumulativeCheckBox.isSelected());
            this.cumulativeBarStepSlider.setEnabled(this.cumulativeCheckBox.isSelected());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    static {
        TITLE = "Taxonomy Mapping Option";
    }
}

