/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataFileDownloader;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.GenomeExporter;
import cgdp.recog.data.GenomeImporter;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.update.AbstractDataUpdater;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Frame;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class DomClustGeneInfoUpdater
extends AbstractDataUpdater {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustGeneInfoUpdater.class);
    private Set organismCodeSet = new HashSet();

    DomClustGeneInfoUpdater(Frame frame, MediatorImpl mediatorImpl) {
        super(frame, mediatorImpl);
    }

    void setOrganismCodeSet(Set set) {
        this.organismCodeSet = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProgressImpl progressImpl) {
        Object object;
        try {
            progressImpl.setTotal(1);
            DataFileDownloader dataFileDownloader = DataFileDownloader.getInstance();
            DataManager.createDataDirectory();
            this.createWorkDir();
            object = this.getWorkDir();
            String string = new File((File)object, "taxonomy.dat").getAbsolutePath();
            String string2 = new File((File)object, "dataVersion").getAbsolutePath();
            String string3 = new File((File)object, "genome.dat").getAbsolutePath();
            String string4 = new File((File)object, "genome_param.dat").getAbsolutePath();
            if (!DataManager.isExistTaxonomyDat()) {
                dataFileDownloader.downloadTaxonomyData(string);
                AbstractDataUpdater.updateDataVersion(string2);
            }
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            dataFileDownloader.downloadGenomeParamData(string4);
            dataFileDownloader.downloadGenomeData(string3);
            GenomeImporter genomeImporter = new GenomeImporter(string3);
            genomeImporter.execute();
            GenomeImporter genomeImporter2 = new GenomeImporter(DataManager.getGenomeDat());
            genomeImporter2.execute();
            List list = genomeImporter2.getGenomeList();
            List list2 = genomeImporter.getGenomeList();
            Set set = DataManager.getOrganismCodeSetNotExistGeneChromosomeFile(this.organismCodeSet);
            set.addAll(this.getUpdateOrganismCodeSet(list, list2, this.organismCodeSet));
            List list3 = this.createUpdateGenmeList(list, list2, set);
            GenomeExporter genomeExporter = new GenomeExporter(list3, string3);
            genomeExporter.execute();
            progressImpl.increment();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.nextProc();
            progressImpl.setCount(-1);
            progressImpl.increment();
            progressImpl.setTotal(set.size());
            dataFileDownloader.downloadGeneAndChromosomeData(set, (File)object, progressImpl);
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            if (!this.downloadFunctionCategory()) {
                return;
            }
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            this.copyFromWorkDir(AccessServer.getDataDir());
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
        }
        catch (Exception exception) {
            object = "Fail to update data files.";
            logger.warn((String)object, exception);
            this.setError(true);
            this.setErrorMessage((String)object);
        }
        finally {
            this.deleteWorkDir();
        }
    }

    public String[] getProgressMessages() {
        return new String[]{"Update taxonomy tree data...", "Update gene data...", "Update function category..."};
    }
}

