/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.update;

import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import java.util.Properties;
import java.util.Vector;

public class SysInfoDownloader
extends SimpleServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(SysInfoDownloader.class);
    private static final String HEADER_PREFIX = "#";
    private static final String SUBSYSTEM_RECOG = "RECOG";
    private Properties sysInfoProperties = new Properties();
    private String serverUrl;

    public SysInfoDownloader() {
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getSysInfoURL());
    }

    public SysInfoDownloader(String string) {
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getSysInfoURL());
        this.serverUrl = string;
    }

    protected String createUrl() {
        if (StringTool.isNull(this.serverUrl)) {
            return super.createUrl();
        }
        String string = this.serverUrl;
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string + this.getContextPath();
    }

    public void parseOutputString(int n, String string) {
        if (string.startsWith(HEADER_PREFIX)) {
            return;
        }
        Vector vector = StringTool.splitString(string, "\t");
        String string2 = (String)vector.get(0);
        if (!string2.equals(SUBSYSTEM_RECOG)) {
            return;
        }
        this.sysInfoProperties.setProperty((String)vector.get(1), (String)vector.get(2));
    }

    public Properties getSysInfoProperties() {
        return this.sysInfoProperties;
    }

    public static Properties downloadSysInfo() {
        try {
            SysInfoDownloader sysInfoDownloader = new SysInfoDownloader();
            sysInfoDownloader.execute();
            Properties properties = sysInfoDownloader.getSysInfoProperties();
            if (sysInfoDownloader.isError()) {
                return null;
            }
            return properties;
        }
        catch (Exception exception) {
            String string = "Fail to download sysinfo.";
            logger.warn(string, exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            SysInfoDownloader sysInfoDownloader = new SysInfoDownloader();
            sysInfoDownloader.execute();
            sysInfoDownloader.getSysInfoProperties();
        }
        catch (Exception exception) {
            logger.warn("Fail to access server.", exception);
        }
    }
}

