/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class AbstractApplyDialog
extends JDialog
implements ActionListener {
    private JPanel buttonPanel;
    protected JButton applyButton;
    protected JButton closeButton;
    private boolean canceled = false;
    private boolean applyClose = true;

    public AbstractApplyDialog(Frame frame) {
        super(frame);
        this.init();
    }

    public AbstractApplyDialog(Dialog dialog) {
        super(dialog);
        this.init();
    }

    protected void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AbstractApplyDialog.this.setCancel();
                AbstractApplyDialog.this.exit();
            }
        });
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.applyButton);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractApplyDialog.this.closeButton.doClick();
            }
        };
        this.closeButton.getInputMap(2).put(KeyStroke.getKeyStroke('\u001b'), "Cancel");
        this.closeButton.getActionMap().put("Cancel", abstractAction);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.applyButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setApplyButtonName(String string) {
        this.applyButton.setText(string);
    }

    public void setCloseButtonName(String string) {
        this.closeButton.setText(string);
    }

    public void setApplyClose(boolean bl) {
        this.applyClose = bl;
    }

    public boolean isApplyClose() {
        return this.applyClose;
    }

    protected JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.applyButton) {
            this.applyBase();
        } else if (actionEvent.getSource() == this.closeButton) {
            this.setCancel();
            this.close();
        }
    }

    public void setCancel() {
        this.canceled = true;
    }

    protected void clearCancel() {
        this.canceled = false;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void applyBase() {
        if (!this.check()) {
            return;
        }
        if (!this.apply()) {
            return;
        }
        this.clearCancel();
        if (this.isApplyClose()) {
            this.exit();
        }
    }

    protected abstract boolean apply();

    protected boolean check() {
        return true;
    }

    private void close() {
        this.exit();
    }

    protected void exit() {
        this.setVisible(false);
        this.dispose();
    }
}

