/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class FileImporter {
    private boolean existParameter = false;
    private boolean readParameter = false;
    private boolean parameterOnly = false;
    private boolean existHeader = true;
    private boolean headerOnly = false;
    private boolean readHeader = false;
    private boolean readData = false;
    private boolean error = false;
    private String errorMessage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        this.beforeProcess();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(this.getFilepath());
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n = 0;
            while ((string = bufferedReader.readLine()) != null && !this.isReadData()) {
                if (!this.isReadParameter() && this.isExistParameter()) {
                    this.parseParameterLine(string);
                    if (!this.isError()) continue;
                    return;
                }
                if (this.isReadParameter() && this.isParameterOnly()) {
                    return;
                }
                if (!this.isReadHeader() && this.isExistHeader()) {
                    this.parseHeaderLine(string);
                    if (this.isError()) {
                        return;
                    }
                    this.setReadHeader(true);
                    if (!this.isHeaderOnly()) continue;
                    return;
                }
                this.parseDataLine(n, string);
                if (this.isError()) {
                    return;
                }
                ++n;
            }
            this.afterProcess();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    protected void beforeProcess() {
    }

    protected void afterProcess() {
    }

    protected abstract String getFilepath();

    protected void parseParameterLine(String string) {
    }

    protected abstract void parseHeaderLine(String var1);

    protected abstract void parseDataLine(int var1, String var2);

    public void setExistParameter(boolean bl) {
        this.existParameter = bl;
    }

    public boolean isExistParameter() {
        return this.existParameter;
    }

    protected void setReadParameter(boolean bl) {
        this.readParameter = bl;
    }

    protected boolean isReadParameter() {
        return this.readParameter;
    }

    public void setExistHeader(boolean bl) {
        this.existHeader = bl;
    }

    private boolean isExistHeader() {
        return this.existHeader;
    }

    public void setHeaderOnly(boolean bl) {
        this.headerOnly = bl;
    }

    private boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public boolean isParameterOnly() {
        return this.parameterOnly;
    }

    public void setParameterOnly(boolean bl) {
        this.parameterOnly = bl;
    }

    public void setReadHeader(boolean bl) {
        this.readHeader = bl;
    }

    public boolean isReadHeader() {
        return this.readHeader;
    }

    public void setReadData(boolean bl) {
        this.readData = bl;
    }

    public boolean isReadData() {
        return this.readData;
    }

    protected void setError(boolean bl) {
        this.error = bl;
    }

    public boolean isError() {
        return this.error;
    }

    protected void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

