/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class PullDownMenuButton
extends JButton {
    private List menuList = new ArrayList();

    public PullDownMenuButton() {
        this.setBorder(new PullDownBorder());
        this.enableEvents(16L);
    }

    public void setMenuList(List list) {
        this.menuList = list;
    }

    public List getMenuList() {
        return this.menuList;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                Border border = this.getBorder();
                Insets insets = border.getBorderInsets(this);
                if (mouseEvent.getX() >= this.getWidth() - insets.right) {
                    this.prepareShowPopupMenu();
                    this.showPopupMenu(0, this.getHeight());
                    this.afterShowPopupMenu();
                    break;
                }
                super.processMouseEvent(mouseEvent);
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                super.processMouseEvent(mouseEvent);
                break;
            }
            default: {
                super.processMouseEvent(mouseEvent);
            }
        }
    }

    protected void prepareShowPopupMenu() {
    }

    protected void afterShowPopupMenu() {
    }

    private void showPopupMenu(int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (JMenuItem jMenuItem : this.menuList) {
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(this, n, n2);
    }

    private static class PullDownBorder
    extends AbstractBorder {
        static final int WIDTH = 8;

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n + n3 - 8, n2 - 1);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(1.0f, n4 / 2 - 1);
            generalPath.lineTo(8.0f, n4 / 2 - 1);
            generalPath.lineTo(4.0f, n4 / 2 + 3);
            generalPath.closePath();
            graphics.setColor(Color.black);
            ((Graphics2D)graphics).fill(generalPath);
            graphics.translate(-(n + n3 - 8), -(n2 - 1));
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawLine(n + n3 - 8 - 1, n2, n + n3 - 8 - 1, n2 + n4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 4, 2, 10);
        }
    }
}

