/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.util.RestrictTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderTextPanel
extends JPanel
implements ChangeListener,
ActionListener,
FocusListener {
    private JSlider slider;
    private RestrictTextField textField;
    private int scale = 1;

    public SliderTextPanel() {
        this.init();
    }

    public static SliderTextPanel createRatioSliderTextPanel() {
        SliderTextPanel sliderTextPanel = new SliderTextPanel();
        sliderTextPanel.setMinimum(0);
        sliderTextPanel.setMaximum(100);
        sliderTextPanel.setTextColumns(3);
        sliderTextPanel.setPaintTicks(true);
        sliderTextPanel.setPaintLabels(true);
        sliderTextPanel.setLabelTable(20);
        return sliderTextPanel;
    }

    public static SliderTextPanel createOneSliderTextPanel() {
        SliderTextPanel sliderTextPanel = new SliderTextPanel();
        sliderTextPanel.setMinimum(0);
        sliderTextPanel.setMaximum(100);
        sliderTextPanel.setTextColumns(3);
        sliderTextPanel.setPaintTicks(true);
        sliderTextPanel.setPaintLabels(true);
        sliderTextPanel.setLabelTable(20);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0"));
        hashtable.put(new Integer(20), new JLabel("0.2"));
        hashtable.put(new Integer(40), new JLabel("0.4"));
        hashtable.put(new Integer(60), new JLabel("0.6"));
        hashtable.put(new Integer(80), new JLabel("0.8"));
        hashtable.put(new Integer(100), new JLabel("1.0"));
        sliderTextPanel.setLabelTable(hashtable);
        sliderTextPanel.setScale(100);
        sliderTextPanel.setDecimal();
        return sliderTextPanel;
    }

    private void init() {
        this.slider = new JSlider();
        this.textField = new RestrictTextField();
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
        this.slider.addChangeListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.textField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.slider, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setDecimal() {
        this.textField.setDecimal(true);
    }

    private double getRealValue(int n) {
        return (double)n / (double)this.getScale();
    }

    private int getVirtualValue(double d) {
        return (int)(d * (double)this.getScale());
    }

    public void setValue(double d) {
        int n = this.getVirtualValue(d);
        this.slider.setValue(n);
        this.textField.setText(String.valueOf(d));
    }

    public void setMinimum(int n) {
        this.slider.setMinimum(n);
    }

    public void setMaximum(int n) {
        this.slider.setMaximum(n);
    }

    public void setTextColumns(int n) {
        this.textField.setColumns(n);
    }

    public void setLabelTable(int n) {
        this.slider.setLabelTable(this.slider.createStandardLabels(n));
    }

    public void setAutoLabelTable() {
        int n = this.slider.getMaximum() - this.slider.getMinimum();
        this.slider.setLabelTable(this.slider.createStandardLabels(n));
    }

    public void setPaintTicks(boolean bl) {
        this.slider.setPaintTicks(bl);
    }

    public void setPaintLabels(boolean bl) {
        this.slider.setPaintLabels(bl);
    }

    public void setLabelTable(Dictionary dictionary) {
        this.slider.setLabelTable(dictionary);
    }

    public void setSnapToTicks(boolean bl) {
        this.slider.setSnapToTicks(bl);
    }

    public void setEnabledComponents(boolean bl) {
        this.slider.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.textField.setEditable(bl);
    }

    public double getValue() {
        return Double.parseDouble(this.textField.getText());
    }

    private void syncThresholdBySlider() {
        this.textField.setText(String.valueOf(this.getRealValue(this.slider.getValue())));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.slider) {
            this.syncThresholdBySlider();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.textField) {
            this.updateSliderValue();
        }
    }

    private void updateSliderValue() {
        String string = this.textField.getText().trim();
        if (!this.validateValue(string)) {
            this.syncThresholdBySlider();
            return;
        }
        this.slider.setValue(this.getVirtualValue(Integer.parseInt(string)));
    }

    private boolean validateValue(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return this.slider.getMinimum() <= n && this.slider.getMaximum() >= n;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.textField) {
            this.updateSliderValue();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }
}

