/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util;

import cgdp.recog.bean.Const;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextConsenser {
    private static final Pattern EXTRACT_TEXT_PATTERN = Pattern.compile(" \\(.*?\\)[ \\.]");
    private static final String KEY_DELIM = "delim";
    private static final String KEY_STOP_WORD = "stop_word";
    private static final String KEY_STOP_WORD2 = "stop_word2";
    private static final String KEY_FREQWORD_CUT = "freqword_cut";
    private static final String KEY_PENALTY = "penalty";
    private static final String KEY_SP_WEIGHT = "sp_weight";
    private TextConsenseCondition condition;
    private List textWeightList = new ArrayList();
    private String maxTitle;
    private String maxTitleOrig;
    private float maxScore;

    public void createCondition() throws IOException {
        this.createCondition(Const.USER_CONSENSE_TITLE);
    }

    public void createCondition(String string) throws IOException {
        this.condition = this.importConfFile(string);
    }

    public void addTitle(String string) {
        if (StringTool.isNull(string)) {
            this.textWeightList.add(new TextWeight(""));
            return;
        }
        Matcher matcher = EXTRACT_TEXT_PATTERN.matcher(string);
        String string2 = matcher.replaceAll("");
        TextWeight textWeight = new TextWeight(string2);
        this.textWeightList.add(textWeight);
    }

    public void clear() {
        this.textWeightList.clear();
    }

    public void execute() {
        Map map = this.createWordCountMap();
        for (String string : map.keySet()) {
            float f = ((Float)map.get(string)).floatValue();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (Object object : map.keySet()) {
            float f3 = ((Float)map.get(object)).floatValue();
            if (this.condition.containsStopWord((String)object)) {
                if (!(f < f3)) continue;
                f = f3;
                continue;
            }
            if (!(f2 < f3)) continue;
            f = f3;
        }
        if (f == 0.0f) {
            f = f2;
        }
        HashSet hashSet = new HashSet();
        for (String string : map.keySet()) {
            float f4;
            float f5 = ((Float)map.get(string)).floatValue();
            if (!(f5 >= (f4 = f * this.condition.getFreqwordCut()))) continue;
            hashSet.add(string);
            if (!this.condition.containsStopWord(string)) continue;
            map.put(string, new Float(f4));
        }
        float f6 = 0.0f;
        String string = null;
        String string2 = null;
        for (TextWeight textWeight : this.textWeightList) {
            float f7 = textWeight.getWeight();
            List list = this.getWordList(textWeight.getText());
            List list2 = this.getUsedDelimiterList(textWeight.getText());
            float f8 = 0.0f;
            String string3 = "";
            HashSet<String> hashSet2 = new HashSet<String>();
            String string4 = "";
            int n = 0;
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string5 = ((String)iterator.next()).trim().toLowerCase();
                bl = false;
                if (this.condition.containsStopWord2(string5) && hashSet.contains(string5)) {
                    bl = n > 0 && hashSet.contains(list.get(n - 1)) && n < list.size() && hashSet.contains(list.get(n + 1));
                } else if (hashSet.contains(string5)) {
                    bl = true;
                }
                if (bl) {
                    if (!hashSet2.contains(string5)) {
                        f8 += ((Float)map.get(string5)).floatValue() * f7;
                    }
                    if (!StringTool.isNull(string3)) {
                        string3 = string3 + string4;
                    }
                    string3 = string3 + string5;
                } else {
                    f8 -= this.condition.getPenalty();
                }
                if (n < list2.size() - 1) {
                    string4 = (String)list2.get(n);
                    ++n;
                }
                hashSet2.add(string5);
            }
            if (!(f8 > f6)) continue;
            string = string3;
            string2 = textWeight.getText();
            f6 = f8;
        }
        this.maxScore = f;
        this.maxTitle = string;
        this.maxTitleOrig = string2;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public String getMaxTitle() {
        return this.maxTitle;
    }

    public String getMaxTitleOrig() {
        return this.maxTitleOrig;
    }

    public List getWordList(String string) {
        return StringTool.extractWords(string, this.condition.getDelimiters());
    }

    private Map createWordCountMap() {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        for (TextWeight textWeight : this.textWeightList) {
            List list = this.getWordList(textWeight.getText());
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = ((String)iterator.next()).trim().toLowerCase();
                if (!hashSet.contains(string)) {
                    Float f = (Float)hashMap.get(string);
                    float f2 = textWeight.getWeight();
                    if (f != null) {
                        f2 += f.floatValue();
                    }
                    hashMap.put(string, new Float(f2));
                }
                hashSet.add(string);
            }
        }
        return hashMap;
    }

    private List getUsedDelimiterList(String string) {
        Pattern pattern = Pattern.compile("[" + this.condition.getDelimiters() + "]");
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList;
    }

    private TextConsenseCondition importConfFile(String string) throws IOException {
        Float f;
        List list;
        List list2;
        ConsenseConfImporter consenseConfImporter = new ConsenseConfImporter(string);
        consenseConfImporter.execute();
        Map map = consenseConfImporter.getConfMap();
        TextConsenseCondition textConsenseCondition = new TextConsenseCondition();
        String string2 = (String)map.get(KEY_DELIM);
        if (!StringTool.isNull(string2)) {
            textConsenseCondition.setDelimiters(string2);
        }
        if (!CollectionUtil.isNull(list2 = (List)map.get(KEY_STOP_WORD))) {
            textConsenseCondition.setStopWordSet(new HashSet(list2));
        }
        if (!CollectionUtil.isNull(list = (List)map.get(KEY_STOP_WORD2))) {
            textConsenseCondition.setStopWordSet2(new HashSet(list));
        }
        try {
            f = (Float)map.get(KEY_FREQWORD_CUT);
            if (f != null) {
                textConsenseCondition.setFreqwordCut(f.floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f = (Float)map.get(KEY_PENALTY);
            if (f != null) {
                textConsenseCondition.setPenalty(f.floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            f = (Float)map.get(KEY_SP_WEIGHT);
            if (f != null) {
                textConsenseCondition.setSpWeight(f.floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return textConsenseCondition;
    }

    public static void main(String[] stringArray) {
        String string = "conf/ConsenseTitle.conf";
        try {
            TextConsenser textConsenser = new TextConsenser();
            textConsenser.createCondition(string);
            textConsenser.addTitle("Chorismate mutase/prephenate dehydratase");
            textConsenser.addTitle("Chorismate synthase");
            textConsenser.addTitle("N-(5'-phosphoribosyl)anthranilate isomerase");
            textConsenser.execute();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private class TextWeight {
        private String text;
        private int weight = 1;

        public TextWeight(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    private class ConsenseConfImporter
    extends FileImporter {
        private static final String DELIMITER = "\t";
        private String filepath;
        private Map confMap = new HashMap();

        public ConsenseConfImporter(String string) {
            this.filepath = string;
            this.setExistHeader(false);
        }

        protected String getFilepath() {
            return this.filepath;
        }

        public Map getConfMap() {
            return this.confMap;
        }

        protected void parseDataLine(int n, String string) {
            Vector vector = StringTool.splitString(string, DELIMITER);
            if (vector.size() != 2) {
                return;
            }
            String string2 = ((String)vector.get(0)).trim().toLowerCase();
            String string3 = ((String)vector.get(1)).trim();
            if (string2.equals(TextConsenser.KEY_STOP_WORD) || string2.equals(TextConsenser.KEY_STOP_WORD2)) {
                ArrayList<String> arrayList = (ArrayList<String>)this.confMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    this.confMap.put(string2, arrayList);
                }
                arrayList.add(string3);
            } else if (string2.equals(TextConsenser.KEY_FREQWORD_CUT) || string2.equals(TextConsenser.KEY_PENALTY) || string2.equals(TextConsenser.KEY_SP_WEIGHT)) {
                try {
                    Float f = new Float(string3);
                    this.confMap.put(string2, f);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.confMap.put(string2, string3);
            }
        }

        protected void parseHeaderLine(String string) {
        }
    }

    private class TextConsenseCondition {
        private String delimiters = " -.,;:/";
        private Set stopWordSet = new HashSet();
        private Set stopWordSet2 = new HashSet();
        private float freqwordCut = 0.3f;
        private float penalty = 0.5f;
        private float spWeight = 2.0f;

        public TextConsenseCondition() {
            this.init();
        }

        private void init() {
            this.initStopWordSet();
            this.initStopWortSet2();
        }

        private void initStopWordSet() {
            this.stopWordSet.add("putative");
            this.stopWordSet.add("probable");
            this.stopWordSet.add("unknown");
            this.stopWordSet.add("hypothetical");
            this.stopWordSet.add("uncharacterized");
            this.stopWordSet.add("predicted");
            this.stopWordSet.add("conserved");
            this.stopWordSet.add("protein");
            this.stopWordSet.add("precursor");
            this.stopWordSet.add("domain");
            this.stopWordSet.add("family");
            this.stopWordSet.add("subunit");
            this.stopWordSet.add("factor");
            this.stopWordSet.add("function");
            this.stopWordSet.add("similarity");
            this.stopWordSet.add("like");
        }

        private void initStopWortSet2() {
            this.stopWordSet2.add("and");
            this.stopWordSet2.add("or");
            this.stopWordSet2.add("the");
            this.stopWordSet2.add("of");
            this.stopWordSet2.add("with");
            this.stopWordSet2.add("in");
            this.stopWordSet2.add("on");
            this.stopWordSet2.add("at");
            this.stopWordSet2.add("to");
            this.stopWordSet2.add("for");
            this.stopWordSet2.add("from");
            this.stopWordSet2.add("as");
        }

        public String getDelimiters() {
            return this.delimiters;
        }

        public void setDelimiters(String string) {
            this.delimiters = string;
        }

        public Set getStopWordSet() {
            return this.stopWordSet;
        }

        public boolean containsStopWord(String string) {
            return this.stopWordSet.contains(string);
        }

        public void setStopWordSet(Set set) {
            this.stopWordSet = set;
        }

        public Set getStopWordSet2() {
            return this.stopWordSet2;
        }

        public boolean containsStopWord2(String string) {
            return this.stopWordSet2.contains(string);
        }

        public void setStopWordSet2(Set set) {
            this.stopWordSet2 = set;
        }

        public float getFreqwordCut() {
            return this.freqwordCut;
        }

        public void setFreqwordCut(float f) {
            this.freqwordCut = f;
        }

        public float getPenalty() {
            return this.penalty;
        }

        public void setPenalty(float f) {
            this.penalty = f;
        }

        public float getSpWeight() {
            return this.spWeight;
        }

        public void setSpWeight(float f) {
            this.spWeight = f;
        }
    }
}

