/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.util.axis;

import cgdp.recog.util.axis.TickUnit;
import java.io.Serializable;
import java.text.NumberFormat;

public class NumberTickUnit
extends TickUnit
implements Serializable {
    private static final long serialVersionUID = 3849459506627654442L;
    private NumberFormat formatter;

    public NumberTickUnit(double d) {
        this(d, NumberFormat.getNumberInstance());
    }

    public NumberTickUnit(double d, NumberFormat numberFormat) {
        super(d);
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.formatter = numberFormat;
    }

    public NumberTickUnit(double d, NumberFormat numberFormat, int n) {
        super(d, n);
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.formatter = numberFormat;
    }

    public String valueToString(double d) {
        return this.formatter.format(d);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberTickUnit)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NumberTickUnit numberTickUnit = (NumberTickUnit)object;
        return this.formatter.equals(numberTickUnit.formatter);
    }

    public String toString() {
        return "[size=" + this.valueToString(this.getSize()) + "]";
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + (this.formatter != null ? this.formatter.hashCode() : 0);
        return n;
    }
}

