#!/usr/bin/perl
#
#
use strict;
use RECOG;
use MBGD::DB;
use RECOG::DomClustCommon;
use RECOG::MBGD::OutputDomClust;
use FileHandle;
use RECOG::DomClust;
use RECOG::MBGD::ClusterTable;

$| = 1;
#
# ơбץư
#
sub execRecogDomclust {
    my ($req) = shift;

	my $db = new MBGD::DB($main::DOMCLUST_DB,{'new' => 1});
    my $od = new RECOG::MBGD::OutputDomClust;

    # ƤΥץϥåݻ
    my $opt_ref = parseCommandOption($req);

	# 顼ϥϥɥ
	my $eH;
	if($opt_ref->{'-err'}) {
		$eH = new FileHandle('>>' . $opt_ref->{'-err'});
	}

    # ץäޤ޵ư줿硢б顼Фƽλ
    if($opt_ref->{'-delete'}) {
		&printSTD($od->output_Error("Not correspond to delete option.",,$opt_ref->{'-out_format'}),$eH);
		return ;
    }

	my $cmd;
	my $status;
	# clusterIDθǵư줿硢ID饳ޥɤ
	if($opt_ref->{'-clusterID'}) {
		# ID¸ߤ뤫å
		# ID¸ߤ硢$opt_refơ
		my $clusterID = $opt_ref->{'-clusterID'};
	    $status = getStatus_fr_id($db,$clusterID) ;
		if(! $status) {
			&printSTD($od->output_Error("clusterID:$clusterID is invalid.",,$opt_ref->{'-out_format'}),$eH);
			return;
		}
		$cmd = getCmd($db, $clusterID);
		my($sp,$opt) = idtoOpt($db, $clusterID);
		foreach my $k (keys%{$opt}) {
			my $v = $opt->{$k};
			$opt_ref->{$k} = $v;
		}
	} else {
		# ingroupץ̵硢顼Фƽλ
		if(!$opt_ref->{'-ingroup'}) {
			&printSTD($od->output_Error("-ingroup option was necessary.",,$opt_ref->{'-out_format'}),$eH);
			return ;
		}
		# ޥɤ饹ơå
		$cmd = &createCmdline($req);
		$status = getStatus_fr_cmd($db, $cmd);
	}

	if(! $status) {
		my $clusterID = getTabid($db, $cmd);
        &printSTD($od->output_Error(-99,$clusterID,$opt_ref->{'-out_format'}), $eH);
        return;
	}

    # ¹Խλ
    if($status == -1) {
        # ¹Է̤Ϥ
		outputDomclustResult($od, $db, $cmd, $opt_ref);
        return;
    }
    # ¹ԽOK
    elsif($status == getppid) {
		# domclustμ¹
		&doExec($od, $cmd, $opt_ref,$eH);
		# ̤ɽ
		my $st = getStatus_fr_cmd($db, $cmd);
		if($st == -1) {
			outputDomclustResult($od, $db, $cmd, $opt_ref);
		} else {
			my $clusterID = getTabid($db, $cmd);
			&printSTD($od->output_Error(3,$clusterID,$opt_ref->{'-out_format'}), $eH);
		}
		return;
    }
	# ȥ饤ǽǧǽʤƼ¹ԡԲǽʤ饨顼Фƽλ
    elsif($status < -1) {
		my $clusterID = getTabid($db, $cmd);
		if(&canRetry($db, $clusterID)) {
			&uploadRetryStatus($db, $clusterID);
			&doExec($od, $cmd, $opt_ref,$eH);
                # ̤ɽ
			my $st = getStatus_fr_cmd($db, $cmd);
			if($st == -1) {
				outputDomclustResult($od, $db, $cmd, $opt_ref);
				return;
			}
		}
		&printSTD($od->output_Error(3,$clusterID,$opt_ref->{'-out_format'}), $eH);
		return;
	}
	# ¾Υץ¹
	elsif($status > 0) {
        if(isAlive($status)) {
		    &printERR("Already running. Please wait running process.\n",$eH);
			my $clusterID = getTabid($db, $cmd);
			# Ľ
			checkExecProg($od, $db, $clusterID, $eH);
		    # ץλ塢ɽ
		    my $st = getStatus_fr_cmd($db, $cmd);
		    if($st == -1) {
			    outputDomclustResult($od, $db, $cmd, $opt_ref);
		    } else {
			    my $clusterID = getTabid($db, $cmd);
			    &printSTD($od->output_Error(3,$clusterID,$opt_ref->{'-out_format'}), $eH);
		    }
		    return ;
	    }
        else {
            # ¾ΥץưƤʤä(ȥ饤ǽĴ롣ǽʤƼ¹)
            my $clusterID = getTabid($db, $cmd);
            if(&canRetry($db, $clusterID)) {
                &uploadRetryStatus($db, $clusterID);
				&doExec($od, $cmd, $opt_ref,$eH);
				# ̤ɽ
				my $st = getStatus_fr_cmd($db, $cmd);
				if($st == -1) {
					outputDomclustResult($od, $db, $cmd, $opt_ref);
				} else {
				    &printSTD($od->output_Error(3,$clusterID,$opt_ref->{'-out_format'}), $eH);
				}
				return;
            } else {
				&printSTD($od->output_Error(3,$clusterID,$opt_ref->{'-out_format'}), $eH);
				return;
			}
        }
    }
	# ¹
	else {
		my $clusterID = getTabid($db, $cmd);
		&printSTD($od->output_Error(-99,$clusterID,$opt_ref->{'-out_format'}), $eH);
		return;
    }
}

# ¹Է̤Ϥ
sub outputDomclustResult {
	my ($od) = shift;
	my ($db) = shift ;
	my ($cmd) = shift;
	my ($opt_ref) = shift;
	
	my $clusterID = getTabid($db, $cmd);
	my $info = getHeaderInfo($db, $clusterID);

	&printSTD($od->write($db, $opt_ref->{'-out_format'}, $opt_ref->{'-output_type'}, $clusterID, $opt_ref->{'-dbtype'}, $info), $opt_ref);

}

# domclust¹Ԥ
# ȤƤӽФ
sub doExec {
	my($od) = shift;
	my($cmd) = shift;
	my($opt_ref) = shift;
	my($eH) = shift;

#	my $pid;
#  FORK: {
#	$pid = fork();
	my $db = new MBGD::DB($main::DOMCLUST_DB, {'new' => 1});
	my $clusterID = getTabid($db, $cmd);
	my $res = updateRunningStatus($db, $clusterID, $$);

#	if($pid) {
#        &checkExecProg($od, $db, $clusterID, $eH);
#		waitpid($pid,0);
#	} 
#	elsif (defined $pid) {
#		# domclustμ¹
		my $dc = new RECOG::DomClust();
		my $r = $dc->exec($clusterID, $cmd);

		# ¹ԥ顼ξ硢顼ơϿƽλ롣
        if(!$r) {
			uploadWarnings($db,$clusterID,$dc->{'TmpErrorfile'});
            exit;
        }

        # domclustwarningФƤDBwarningϿ
		if(-s $dc->{'TmpErrorfile'}) {
			uploadWarnings($db,$clusterID,$dc->{'TmpErrorfile'});
		}

		# 饹ơ֥ȤƼ롣		
		my $ctbl;
		my($ing, $outg, $species) = &uniqSpecies($opt_ref);
		$ctbl = $dc->getClusterTableInst($cmd, $ing, $outg, $species);
	
        # 饹DBϿ
		my $cluster_Count = $dc->{'ClusterCount'};
		uploadNdomclust($db,$clusterID,$cluster_Count);

        # ǡɲä
		$ctbl->addGeneInfoFuncLog2($dc->{'TmpProgfile'});

        # domclustμ¹Է̤cluster_result_$clusterIDϿ
		my $cfile = $dc->{'Tmpfile'};
		createResultTable($db,$clusterID,$cfile);

        # ե󥯥ǡDBϿ
        $ctbl->write($db,(format => 'db',
                          FuncDB => $main::TBL_DOMFUNC_DB,
                          GeneDesc => $main::TBL_DOMFUNC_GENE,
                          clusterID => $clusterID)
                     );
        # λơDBϿ
        my $optionlines = 'clusterID=' . $clusterID . " " .
                          'clusternum=' . $cluster_Count . " " .
                          'spec='      . join(",", @$species) . " " .
                          'ingroup='   . join(",", @$ing) . " " .
                          'outgroup='  . join(",", @$outg);

		uploadFinishStatus($db,$clusterID,$optionlines);

#		exit;
#	} else {
#        die "Can't fork: $\n";
#    }

#} # End Of Label:FORK

    return;
}

# ץοĽƻ뤹
sub checkExecProg {
	my $od = shift;
	my $db = shift;
	my $id = shift;
	my $eH = shift;

	my $res = "";
	my $stdoutfile = $main::DOMCLUST_TMP_DIR . "/". $main::PREF_DOMCLUST_PROG . "_" . $id;
	while(! -f $stdoutfile) {
		sleep(1);
	}

	while(&getStatus_fr_id($db,$id) > 0) {
		my $log = `tail -n 3 $stdoutfile`;
		if($log eq $res) {
			next;
		}
		else {
			my ($status, $per) = $od->getNowProg($db, $id);
			$res = $log;
			my $line = "";
			if($per) {
				$line = "STATUS::$status >> $per %\n";
			} else {
				$line = "STATUS::$status\n";
			}

			printERR($line, $eH);
		}
	}
	return;
}

sub printSTD {
	my $line = shift;
    my ($opt_ref) = shift;

    my $file = $opt_ref->{'-out'};
    if($file) {
        my $fh = new FileHandle('>' .$file);
        if($fh) {
            print $fh $line;
        } else {
            print STDOUT $line;
        }
    } else {
        print STDOUT $line;
    }
}

sub printERR {
	my $line = shift;
	my $eH = shift;

	if($eH) {
		print $eH $line;
	} else {
		print STDERR $line;
	}
}

if($0 eq __FILE__) {
	if(!@ARGV){
		die "please input option.";
	}
	&execRecogDomclust(join(" ",@ARGV));
	exit;
}

###
1;#
###
