#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD;
use RECOG;

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -mode='gene' -tabid=TABID fileDomClustResults\n";
}

sub printFuncUsage {
	print STDERR "Usage :: $0 -mode='func' -tabid=TABID fileDomClustResults\n";
}

###############################################################################
if ($0 eq __FILE__) {

	my($db) = new MBGD::DB($main::dbname);

	if ($main::mode eq 'gene') { 
		if (!$main::tabid) {
			printUsage();
			exit(0);
		}

		my($file) = shift(@ARGV);
		if (! -e $file) {
			printUsage();
			exit(0);
		}

		createResultTableAndLoad($db, $main::tabid, $file);
	}
	elsif($main::mode eq 'func') {
		if (!$main::tabid) {
			printUsage();
			exit(0);
		}

		my($file) = shift(@ARGV);
		if (! -e $file) {
			printUsage();
			exit(0);
		}

		createFunctionTableAndLoad($db, $main::tabid, $file);
	}
	else {
		print STDERR "please select -mode=[gene] or [func]\n";
	}
}

###############################################################################
1;#
###############################################################################
