#!/usr/bin/perl -s
use strict;
use Getopt::Long;
use IO::File;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -TABID=table_id [-DBNAME=db_name] file_domclust_tree\n";

    return;
}

###############################################################################
#
sub get_table_name {
    my($table_id) = shift;

    my($table_name) = 'clusttree_' . $table_id;

    return $table_name;
}

###############################################################################
#
sub create_table {
    my($db) = shift;
    my($table_id) = shift;
    my($sql);

    #
    my($table_name) = get_table_name($table_id);

    #
    $sql = 'drop table if exists ' . $table_name;
    $db->execute($sql);

    #
    $sql = q{CREATE TABLE } . $table_name . q{(}
         . q{clustid int(11)     NOT NULL default '0',}
         . q{tree    mediumtext,}
         . q{PRIMARY KEY  (clustid)}
         . q{)};
    $db->execute($sql);

    return;
}

###############################################################################
#
sub insert_domclust_tree {
    my($db) = shift;
    my($table_name) = shift;
    my($clust_tree_ref) = shift;

    # escape
    my($tree) = quotemeta($clust_tree_ref->{'CLUST_TREE'});

    my($sql) = q{insert } . $table_name
             . q{(clustid, tree)}
             . q{values}
             . q{(} . $clust_tree_ref->{'CLUST_ID'} . q{,'} . $tree . q{')};
    $db->execute($sql);

    return;
}

###############################################################################
#
sub parse_domclust_tree {
    my($db) = shift;
    my($table_id) = shift;
    my($filename) = shift;

    #
    create_table($db, $table_id);

    my($file_dom_tree) = "$ENV{'MBGD_HOME'}/work/dom_tree.$$";
    my($fh_dom_tree) = IO::File->new($file_dom_tree, "w");

    #
    my($table_name) = get_table_name($table_id);
    my($clust_tree_ref);
    my($fh) = IO::File->new($filename, "r");
    while(my$line=$fh->getline()) {
        if ($line =~ /^\s*$/) {
            next;
        }
        elsif ($line =~ /^HomCluster\s(\d+)/) {
            next;
        }
        elsif ($line =~ /^Cluster\s(\d+)/) {
            my($clust_id) = $1;
            if (defined($clust_tree_ref)) {
#                insert_domclust_tree($db, $table_name, $clust_tree_ref);
                my($tree) = quotemeta($clust_tree_ref->{'CLUST_TREE'});
                $fh_dom_tree->print(join("\t", $clust_tree_ref->{'CLUST_ID'},
                                               $tree), "\n");
            }

            $clust_tree_ref = {};
            $clust_tree_ref->{'CLUST_ID'}   = $clust_id;
            $clust_tree_ref->{'CLUST_TREE'} = '';
        }
        else {
            $clust_tree_ref->{'CLUST_TREE'} .= $line;
        }
    }
    $fh->close();

    #
    if (defined($clust_tree_ref)) {
#        insert_domclust_tree($db, $table_name, $clust_tree_ref);
        my($tree) = quotemeta($clust_tree_ref->{'CLUST_TREE'});
        $fh_dom_tree->print(join("\t", $clust_tree_ref->{'CLUST_ID'},
                                       $tree), "\n");
    }
    $fh_dom_tree->close();

    #
    my($sql) = "load data local infile '$file_dom_tree' "
             . "replace "
             . "into table $table_name "
             . "(clustid, tree)";
    $db->execute($sql);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($db_name) = $main::DBNAME_MBGD;
    if (defined($main::DBNAME)) {
        $db_name = $main::DBNAME;
    }
    if (!defined($main::TABID)) {
        printUsage();
        exit(0);
    }

    my($db) = MBGD::DB->new($db_name);
    foreach my$file (@ARGV) {
        parse_domclust_tree($db, $main::TABID, $file);
        last;
    }
}

1;#
