#!/usr/bin/perl -s

use MBGD;
use MBGD::DB;
use RECOG::FindcoreUtil;

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 -CORE_TAB_ID file_findcore_err\n";
}

###############################################################################
#
sub updateFindcoreProgress {
    my($db) = shift;
    my($coreTabId) = shift;
    my($filename) = shift;

    FindcoreUtil::parseProgress($db, $coreTabId, $filename);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    if (!defined($main::CORE_TAB_ID)) {
        printUsage();
        exit(-1);
    }
    my($coreTabId) = $main::CORE_TAB_ID;

    #
    my($dbname) = $main::DBNAME_RECOG;
    if (defined($main::DBNAME)) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($filename) = shift(@ARGV);
    $filename = '-' if (!defined($filename));

    #
    updateFindcoreProgress($db, $coreTabId, $filename);
}

###############################################################################
1;
###############################################################################
