#!/usr/bin/perl -s
use strict;
use MBGD::DB;

###############################################################################
sub print_usage {

    print STDERR "Usage :: $0 [ -DBNAME=dbname ] -TABID=tabid\n";

    return;
}

###############################################################################
sub conv_addinfo_in {
    my($dbname) = shift;
    my($tabid) = shift;

    my($db) = MBGD::DB->new($dbname);

    #
    my($tab) = 'cluster_tables_idx';
    my($sql) = "select * from $tab where clusterID=?";
    my($sth) = $db->prepare($sql);
    $sth->execute($tabid);
    my($ref) = $sth->fetchrow_hashref();
    print '#', $ref->{'cmd'}, "\n";

    #
    my($tab) = 'cluster_func_clust2sql_' . $tabid;
    my($sql) = "select * from $tab order by clustid, subclustid";
    my($sth) = $db->execute($sql);
    while (my$ref=$sth->fetchrow_hashref()) {
        print $ref->{'clustid'},    "\t";
        print $ref->{'subclustid'},    "\t";
        print $ref->{'homclustid'}, "\t";
        print $ref->{'spnum'},      "\t";
        print $ref->{'data'},       "\n";
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($tabid) = $main::TABID;
    if (!$tabid) {
        print_usage();
        exit(0);
    }

    conv_addinfo_in($dbname, $tabid);
}

1;#
