#!/usr/bin/perl -s
use strict;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub create_domclust_mbgd_o11 {
    my($db) = shift;
    my($tabid) = shift;

    my($tab) = 'cluster_tables';
    my($sql) = "select * from $tab where tabid='$tabid'";
    my($sth) = $db->execute($sql);
    if ($sth->rows() == 0) {
        print STDERR "Can not found cluster table for '$tabid'\n";
        return;
    }

    my($ref) = $sth->fetchrow_hashref();
    my($cmd) = $ref->{'cmd'};
    $cmd =~ s#\s+\-t\/\S+##;
    $cmd =~ s#\s+\-Otax\S+##;
    $cmd =~ s#\s+\-Ometa\S+##;
    $cmd =~ s#\s+\-Ometa\S+##;
    $cmd =~ s#\s+\-baseClusterID\S+##;

    $cmd =~ s#\|\s+\S+clusttree2flat\.pl.+$##;  # domclust $B0J9_$N=hM}$r:o=|(B

    $cmd =~ s# -o1 # -o11 #;
    print $cmd, "\n";

    my($file_o11) = "$ENV{'MBGD_HOME'}/MBGD.tmp/tmp_dom_res_$tabid.o11";
    system("$cmd > $file_o11");

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = $main::DBNAME_TMP;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }

    my($db) = MBGD::DB->new($dbname);
    foreach my$tabid (@ARGV) {
        create_domclust_mbgd_o11($db, $tabid);
    }
}
###############################################################################
1;#
###############################################################################
