#!/usr/bin/perl -s

#
# Usage : $0 [-defaulttab] filename
#

use MBGD;
use FileHandle;
require "MBGD_Conf.pl";

$filename = $ARGV[0];
if (! $tabID) {
	($tabID) = $filename =~ /(\d+)$/;
}

$dbname = $ENV{'MYSQL_DBTMP'} if (! $dbname);

if ($defaulttab) {
    require "MBGD_commonUpdate.pl";
    $dbname = $UPD_dbiTmp;
}
$tmpout = "$DIR_tmp/tmpdbout.$$";
$tmpout2 = "$DIR_tmp/tmpdbout2.$$";	## for tree file
$db = MBGD::DB->new($dbname);

open(F, $filename) || die("Can not open $filename($!)");
open(OUT, ">$tmpout") || die "Can't open $tmpout\n";
open(OUT2, ">$tmpout2") || die "Can't open $tmpout\n";
$Ldelim = "#@#";

while (<F>) {
	if (/^#\s*(.*)$/) {
		next if ($flag);
		$cmd = $1;
		($spec) = ($cmd =~ /SPEC=(\S+)/);
		&insertMetaTable($spec, $cmd, $tabID) if (! $test);
		$flag = 1;
	} elsif (/^Cluster ([0-9]+)/) {
		if ($clustid && $clusttree) {
			print OUT2 join("\t", $clustid, $clusttree), "$Ldelim";
			$clusttree = '';
		}
		$clustid = $1;
	} elsif (/[\+\*]\- (.*)$/) {
		($spname,$from,$to) = split(/\s+/, $1);
		if ($spname =~ /(.*)\((\d+)\)/) {
			($spname, $dom) = ($1, $2);
		} else {
			$dom = 0;
		}
		($sp,$name) = split(/:/, $spname);
		print OUT join("\t", $clustid, $sp, $name, $spname, $dom, $from, $to), "\n";
		$clusttree .= $_;
	} elsif (/^$/) {
	} else {
		$clusttree .= $_;
	}
}
if ($clustid && $clusttree) {
	print OUT2 join("\t", $clustid, $clusttree), "\n";
}
close(OUT2);
close(OUT);
close(F);
exit if ($test);

## creating the cluster table
$db->execute("drop table if exists cluster_$tabID");
$db->execute("create table cluster_$tabID (
		clustid int,
		sp char(5) not null,
		name char(24) not null,
		spname char(30) not null,
		dom smallint not null,
		from1 int,
		to1 int,
		primary key (spname, dom),
#		key (clustid),
		unique key (sp, name, dom))");

$db->execute("load data local infile '$tmpout' REPLACE into table cluster_$tabID");
$db->execute("create index cluster_id_idx_$tabID on cluster_$tabID (clustid)");

## creating the clusttree table
$db->execute("drop table if exists clusttree_$tabID");
$db->execute("create table clusttree_$tabID (
		clustid int not null,
		tree mediumtext,
		primary key (clustid))");
$db->execute("load data local infile '$tmpout2' REPLACE into table clusttree_$tabID lines terminated by '$Ldelim'");


undef($db);

unlink("$tmpout");
unlink("$tmpout2");

exit;

###############################################################################
#
sub insertMetaTable {
	my($spec, $cmd, $tabID) = @_;
	$db->execute("create table if not exists cluster_tables " .
		"(spec text, cmd text,
		tabid char(12) not null,
		cdate timestamp,
		primary key(tabid))");
if (0) {
	my $sth = $db->{conn}->prepare("select tabid from cluster_tables " .
		"where spec = ? and cmd = ?");
	$sth->execute($spec, $cmd);
	if ($sth->fetchrow_array) {
		return 1;
	}
}
#	$sth = $db->{conn}->prepare("insert into cluster_tables " .
	$sth = $db->{conn}->prepare("replace into cluster_tables " .
		"(spec, cmd, tabid, cdate) values (?, ?, ?, null)");
	$sth->execute($spec, $cmd, $tabID);
	return 0;
}

###############################################################################
1;#
###############################################################################
