#!/usr/bin/perl -s
use strict;
use LWP::UserAgent;
use HTTP::Request::Common;
use RecogProjectCommon;
$main::DEBUG = 1;

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 -PROJ_ID=project_id -CONF_ID=base_cluster_conf_id -FILE=filename_out -DIR=dir_database ]\n";

    return;
}

###############################################################################
#
sub save_tabidx {
    my($exec_server) = shift;
    my($exec_port) = shift;
    my($tabid) = shift;
    my($file_tabidx) = shift;

    #
    my($url) = sprintf("http://%s:%d/htbin/RECOG/getData", $exec_server, $exec_port)
             . '?' . 'table=cluster_tables_idx'
             . '&' . 'clusterID=' . $tabid;

    my($cmd) = "$main::CMD_curl '$url'";
    print STDERR "CMD :: $cmd\n" if ($main::DEBUG);
    system("$cmd > $file_tabidx");

    return;
}

###############################################################################
#
sub get_base_cluster {
    my($project_id) = shift;
    my($base_cluster_conf_id) = shift;
    my($file_out) = shift;
    my($dir) = shift;

    #
#    my($exec_server) = 'mbgd.genome.ad.jp';
#    my($exec_port)   = '80';
    my($exec_server) = 'bias.nibb.ac.jp';
    my($exec_port)   = '8044';
    my($url) = sprintf("http://%s:%s/htbin/RECOG/domclust.cgi", $exec_server,
                                                                $exec_port);

    if (!$dir) {
        $dir = sprintf("%s/database.work", $ENV{'RECOG_HOME'});
    }
    my($file_conf) = RecogProjectCommon::get_file_cluster_conf($project_id,
                                                               $base_cluster_conf_id,
                                                               $dir);
    my($base_cluster_conf_ref) = RecogProjectCommon::load_base_cluster_conf($file_conf);
    if (!$base_cluster_conf_ref) {
        print STDERR "ERROR :: Can not found base-cluster-config-file\n";
        return;
    }

    #
    my($form_ref) = {};
    my(@key_list) = sort keys(%{$base_cluster_conf_ref});
    foreach my$key (@key_list) {
        my($val) = $base_cluster_conf_ref->{"$key"};
        next if ($val =~ /^\s*$/);

        $form_ref->{"$key"} = $val;
    }

    $form_ref->{'output_format'} = 'o11';
    $form_ref->{'output_type'}   = 'complete';

    #
    my($tabid);
    for (;;) {
        print STDERR "LOG :: Post()\n";
        my($lwp_ua) = LWP::UserAgent->new();
        my($request) = HTTP::Request::Common::POST($url, $form_ref);
        my($res) = $lwp_ua->request($request);

        #
        my(@line_list) = split(/[\r\n]+/, $res->content());
        my($status);
        foreach my$line (@line_list) {
            if ($line =~ /^#CLUSTER_ID\=(.+)$/i) {
                $tabid = $1;
            }
            elsif ($line =~ /^#status2\=(\.+)/i) {
                my($msg) = $1;
                if ($status =~ /\=error$/) {
                    print $msg, "\n";
                    exit(-1);
                }
            }
            elsif ($line =~ /^#status\=running$/i) {
                print STDERR "Waiting...\n";
                sleep(30);
                last;
            }
            elsif ($line =~ /^#status\=finished$/i) {
                if ($file_out) {
                    my($fh) = IO::File->new("$file_out", 'w');
                    $fh->print($res->content());
                    $fh->close();

                    save_tabidx($exec_server, $exec_port, $tabid, "$file_out.tabidx");
                }
                else {
                    print $res->content();
                }
                exit(0);
            }
            elsif ($line =~ /^#status\=/i) {
                $status = $line;
            }
            elsif ($line =~ /^#start_data$/i) {
                last;
            }
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($project_id) = $main::PROJ_ID;
    my($base_cluster_conf_id) = $main::CONF_ID;
    my($file_out) = $main::FILE;
    my($dir) = $main::DIR;
    get_base_cluster($project_id, $base_cluster_conf_id, $file_out, $dir);
}

###############################################################################
1;#
###############################################################################
