#!/usr/bin/perl -s
use strict;
use MBGD::DB;
#use DBI;
require "MBGD_Conf.pl";

die "Usage: $0 [-SPEC=splist -SCORE=# -PAM=# -EVAL=# -IDENT=#] genename\n" if (! @ARGV);

###############################################################################
#
sub select_homolog_list {
    my($db) = shift;
    my($genename) = shift;
    my($order) = shift;

    #
    my($sp, $name) = split(/:/, $genename);
    my($sql) = "select chksum from prot_chksum where sp=? and name=?";
    my($sth) = $db->prepare($sql);
    $sth->execute($sp, $name);
    my($chksum) = $sth->fetchrow_array();

    my($tables) = " $main::DBNAME_ACCUM.homology h, prot_chksum c";

    my($wopt) = '1';
    if ($main::SPEC) {
        my(@splist) = split(/,/, $main::SPEC);
        $wopt .= " and c.sp in('" . join("','", @splist) . "')" ;
    }
    if ($main::PAM) {
        $wopt .= sprintf(" and h.pam <= %d", $main::PAM);
    }
    if ($main::EVAL) {
        $wopt .= sprintf(" and h.eval <= %f", $main::EVAL);
    }
    if ($main::SCORE) {
        $wopt .= sprintf(" and h.score >= %d", $main::SCORE);
    }
    if ($main::IDENT) {
        $wopt .= sprintf(" and h.ident >= %f", $main::IDENT);
    }

    #
    my($addfld) = '';
    if ($main::ADDLEN) {
        $addfld  = "g.aalen";
        $tables .= ", gene g";
        $wopt   .= " and c.sp=g.sp and c.name=g.name";
    }

    #
    my(@Results);
    my(%Find);
    my($fields) = "c.sp,c.name,h.from1,h.to1,h.from2,h.to2,h.ident,h.eval,h.pam,h.score $addfld";
    my($sql) = "select $fields from $tables where h.name1=? and h.name2=c.chksum and $wopt";
    my($sth) = $db->prepare($sql);
    $sth->execute($chksum);
    while (my$res = $sth->fetchrow_hashref()) {
        push(@Results, $res);
#        # for duplication check
        $Find{"$res->{sp}:$res->{name}"} = 1;
    }

    #
    my($fields) = "c.sp,c.name,h.from2,h.to2,h.from1,h.to1,h.ident,h.eval,h.pam,h.score $addfld";
    my($sql) = "select $fields from $tables where h.name2=? and h.name1=c.chksum and $wopt";
    print STDERR "DBG :: SQL :: $sql\n" if ($mian::DEBUG);
    my($sth) = $db->prepare($sql);
    $sth->execute($chksum);
    while (my$res = $sth->fetchrow_hashref()) {
        ## duplication check
        next if ($Find{"$res->{sp}:$res->{name}"});
        push(@Results, $res);
    }

    #
    if ($order eq 'score') {
        @Results = sort {$b->{score}<=>$a->{score}} @Results;
    }
    elsif ($order eq 'pam') {
        @Results = sort {$a->{pam}<=>$b->{pam}} @Results;
    }
    foreach my$res ( @Results ) {
        if ($main::ORIGOUT) {
            print join(" ", $genename, "$res->{sp}:$res->{name}",
                       $res->{from1}, $res->{to1}, $res->{from2}, $res->{to2},
                       $res->{ident}, $res->{eval}, $res->{pam}, $res->{score}), "\n";
        }
        else {
            print join(" ", $genename, "$res->{sp}:$res->{name}",
                       $res->{from1}, $res->{to1}, $res->{from2}, $res->{to2},
                       $res->{pam}, $res->{score}), "\n";
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($genename) = $ARGV[0];

    my($order) = 'score';
    if (defined $main::ORDER) {
        $order = $main::ORDER;
    }

    my($dbname) = $main::DBNAME_MBGD;
    if (defined $main::DBNAME) {
        $dbname = $main::DBNAME;
    }

    my($db) = MBGD::DB->new($dbname);
    select_homolog_list($db, $genename, $order);
}

1;#
