#!/usr/bin/perl -s
#
$main::DEBUG=1;
use MBGD;
use MBGD::WWW;
use MBGD::FuncCat;
use DBXref;
use MBGD::FunctionCategory;

require "MBGD_Conf.pl";

require "libMBGDaxes.pl";
require "emergency.pl";

#require "libMBGDFuncCat.pl";
#require "libMBGDUserInfo.pl";
#use CGI;
#require "MBGD_common.pl";

$| = 1;

$WWW = MBGD::WWW->new;

###############################################################################
%Args = $WWW->cgiGetArgs;
if (! $Args{$spec} && $Args{"name"} =~ /:/) {
	($Organism, $GeneName) = split(/:/, $Args{"name"});
} else {
	$Organism = $Args{"spec"};
	$GeneName = $Args{"name"};
}


# $B%0%m!<%P%kJQ?tDj5A(B
$Path_htbin       = $MBGD_PATH_HTBIN;

#
$db = MBGD::DB->new($ENV{'MYSQL_DB'});

if ( (!$Organism || ! $GeneName) && $Args{'protid'}) {
	$ProtID = $Args{'protid'};
	($geneInfo) = MBGD::Gene->find($db, "protid='$ProtID'");
	if (! $geneInfo) {
		my($opt);
		$opt = {'tablename' => 'gene'};
		($geneInfo) = MBGD::Gene->find($db, "protid='$ProtID'", $opt);
	}
	$Organism = $geneInfo->{'sp'};
	$GeneName = $geneInfo->{'name'};
}

# get genome info
($genomeInfo) = MBGD::Genome->get($db, ["$Organism"]);

$WWW->setOptions(title=>"Function Category [$Organism:$GeneName]");

# get gene info
($geneInfo) = MBGD::Gene->get($db, ["$Organism:$GeneName"]);
if (! $geneInfo) {
	my($opt);
	$opt = {'tablename' => 'gene'};
	($geneInfo) = MBGD::Gene->get($db, ["$Organism:$GeneName"], $opt);
}

$WWW->start_html('-style' => {src=>['/css/mbgd.css', '/css/mbgd_button.css']});

#print "<b> Function Category </b>\n";

print "<TABLE border=\"0\" cellpadding=\"4\">\n";

# Function Category
$objFuncCatMbgd = new MBGD::FunctionCategory('mbgd');
#$objFuncCatMbgd->setOrig(1);
$objFuncCatCog  = new MBGD::FunctionCategory('cog');
#$objFuncCatCog->setOrig(1);
$objFuncCatKegg = new MBGD::FunctionCategory('kegg');
#$objFuncCatKegg->setOrig(1);
$objFuncCatTigr = new MBGD::FunctionCategory('tigr');
#$objFuncCatTigr->setOrig(1);


# $B%/%i%9%?%j%s%07k2L!J(Ball$B!K$r;H$$(B FunctionCategory $B$r<hF@I=<($9$k(B
print "<TR>";
print "<table border>\n";

$opt = {'fromdb' => 1};
foreach my$dbType ('MBGD', 'COG', 'KEGG', 'TIGR') {
    my($obj);
    $obj = $objFuncCatMbgd if ($dbType =~ /^MBGD/i);
    $obj = $objFuncCatCog  if ($dbType =~ /^COG/i);
    $obj = $objFuncCatKegg if ($dbType =~ /^KEGG/i);
    $obj = $objFuncCatTigr if ($dbType =~ /^TIGR/i);

    my($refList) = $obj->getFunctionListBySporf($Args{"name"}, $opt);
    foreach my$ref (@{$refList}) {
        my($lev) = $ref->{'LEVEL'};
        my($name) = $obj->getFunctionFullnameByLevel($lev);
        my($color) = $obj->getFunctionColorByLevel($lev);
        print "<tr><th>$dbType</th><td bgcolor=\"#$color\">[$lev] $name</td></tr>\n";
    }
}

print "</table>\n";
print "</TR>\n";

##
print "</TABLE>\n";


print "</BODY>\n";
print "</HTML>\n";

exit;

###############################################################################
1;#
###############################################################################
