#!/usr/bin/perl -s
###############################################################################
# ꤵ줿꡼οޤ
###############################################################################

use CGI;
use GD;
use MBGD::FuncCat;
use MBGD::ClustTab::DB;
use MBGD::WWW;
use MBGD::FunctionCategory;
use MBGD::Contig;
require "MBGD_common.pl";
require "libMBGDImg.pl";
require "libMBGDaxes.pl";
##require "libMBGDUserInfo.pl";
require "emergency.pl";

$WWW = MBGD::WWW->new;
$uInfo = $WWW->uInfo;

if( defined( $ENV{'QUERY_STRING'} )) {
    my($cgi) = CGI->new();

    $Organism   = $cgi->param("spec");
    $chrid      = $cgi->param("chrid");
    $contigid   = $cgi->param("contigid");
    $RegCenter  = $cgi->param("pos");
    $RegWidth   = $cgi->param("width");
    $Reverse     = $cgi->param("dir");
    $GeneName   = $cgi->param("name");
    $Dom_num    = $cgi->param("dom");
    $DispMode   = $cgi->param("mode");
    @GeneColor  = $cgi->param("color");

    #
    $pref = $uInfo->loadProperty("Property::Preference");
    $funccatType = $pref->getValue('funccat_type');
    $refFunccat = new MBGD::FunctionCategory($funccatType);
}
else {
    die "Parameter Error !!\n" if( scalar( @ARGV ) < 4 );
    ( $Organism, $Sequence, $RegCenter, $RegWidth,
      $Reverse, $GeneName, @GeneColor ) = @ARGV;
}

#
# Хѿ
#
if($DispMode eq 'multi') {
    @MBGD_REGION_IMG_SIZE  = (750, 80);        # ᡼
    @MBGD_REGION_IMG_SEQ   = (0, 40, 750, 40); # (rectangle)ΰ
    @MBGD_REGION_IMG_SCALE = (0, 40, 750, 40); # ɽ 
    $MBGD_REGION_IMG_SEQ_WIDTH    = 1;         # Υ(Ĥκ)
    $MBGD_REGION_IMG_GENOME_COLOR = "0_0_0";   # ΥΥǥեȥ顼
    $noOrfName                    = 0;         # ORF̾ɽ
}
elsif ($DispMode eq 'multi_noname') {
    @MBGD_REGION_IMG_SIZE  = (750, 50);        # ᡼
    @MBGD_REGION_IMG_SEQ   = (0, 25, 750, 25); # (rectangle)ΰ
    @MBGD_REGION_IMG_SCALE = (0, 25, 750, 25); # ɽ 
    $MBGD_REGION_IMG_SEQ_WIDTH    = 1;         # Υ(Ĥκ)
    $MBGD_REGION_IMG_GENOME_COLOR = "0_0_0";   # ΥΥǥեȥ顼
    $noOrfName                    = 1;         # ORF̾ɽʤ
}

if (! @GeneColor && $DispMode eq 'normal') {
    my $clusttab = 'all' if (! $clusttab);
    my $beg = $RegCenter - $RegWidth/2;
    my $end = $RegCenter + $RegWidth/2;
    my @out = MBGD::ClustTab::DB::getSortedClusterSimple($clusttab,
                                                         $Organism,
                                                         $chrid,
                                                         $contigid,
                                                         {region=>"$beg:$end"});
    foreach my $g (@out) {
        my $ent;
        my $funccat;
        my $color;

        $ent = "$g->{'sp'}:$g->{'name'}";
        $funccat = $g->{funccat};
        if ($refFunccat) {
            my($opt) = {'fromdb' => '1'};
            my($refFuncList) = $refFunccat->getFunctionListBySporf($ent, $opt);
            my($refFunc) = $refFuncList->[0];
            $funccat = $refFunc->{'LEVEL'};
        }

        if (! $FuncColor{$funccat}) {
            my(@dec);
            my($fcol);
            if ($g->{'type'} =~ /rna/i) {
                $funccat = 'rna';
                $fcol = '000080';
            }
            elsif ($refFunccat) {
                $fcol = $refFunccat->getFunctionColorByLevel($funccat);
            }
            else {
                $fcol = &MBGD::FuncCat::get_func_color_from_id($funccat);
            }
            for (my $i = 0; $i < 6; $i+=2) {
                push(@dec, hex substr($fcol, $i, 2));
            }
            $FuncColor{$funccat} = join('_', @dec);
        }
        push(@GeneColor,"$g->{name}:$FuncColor{$funccat}:1:0:0");
#print STDERR "DBG :: $g->{name} :: $funccat :: $FuncColor{$funccat}:1:0:0\n";
    }
    $MODE = 'funccat';
}

#
# ꡼ˤҾѥޥɤ
#

my$optImg = {};
$optImg->{'Reverse'} = $Reverse;
$optImg->{'NoOrfName'} = $noOrfName;
@commands = &MBGDImg_Layout( $Organism, $chrid, $contigid, $RegCenter, $RegWidth, $optImg);

#for $x (@commands){
#	print STDERR "B>$x\n";
#}

# 
# ̾ꤵƤ硢ΰοѹ롣
# 

if( defined( $GeneName )) {
    my( $first_line ) = shift( @commands );

    # ?????ΰ '' ɤĤ֤
    unshift( @commands, "color 255_0_0\n" );

    if ($MODE eq 'funccat') {
        foreach $gc (@GeneColor) {
            my( $gene,$color ) = split( /:/, $gc );
            for (my $i = 0; $i < @commands; $i++) {
                $commands[$i] =~ s/^(\s*(fill|rect)\s.+\s)\S+(\s+$gene\s*)$/$1 $color $3/i;
            }
            unshift( @commands, "color $color\n" );
        }
    } elsif( scalar( @GeneColor )) {
        my %GeneColorHash;
        foreach $gc (@GeneColor) {
            my( $gene,$color,$dom,$from,$to ) = split( /:/, $gc );
            push(@{$GeneColorHash{$gene}}, $gc);
        }
        
        foreach $gene (keys %GeneColorHash) {
            my($rectx0, $rectx1, $rectx1, $recty1);
            my(@domLine,$drawCmdNew);
            while ($drawCmd = shift @commands) {
print STDERR "DBG :: ORG[$gene] :: ##$drawCmd##\n";

                if ($drawCmd =~ /^nop.*\s${gene}\b*/) { # gene  from-to
                    ($dmy,$rectx0,$recty0,$rectx1,$recty1,$rectcolor,$comment) = split(/\s+/,$drawCmd);

                    foreach $gdata (@{$GeneColorHash{$gene}}) {
                        my( $g0, $color, $dom, $from,$to ) = split( /:/, $gdata );
                        $dom  = 1 if (! $dom);
                        $from = 0 if (! $from);
                        $to   = 1 if (! $to);

                        ## AHO!! : 40 < $recty0 means gene_direction < 0 
                        ##       renumbering domain number
                        if (40 < $recty0) {
                            my $tmpfrom = $from;
                            $from = 1 - $to; $to = 1 - $tmpfrom;
                        }

                        ## determine the domain region to be colored
                        my($x0, $y0, $x1, $y1);
                        $x0 = int($rectx0 + ($rectx1 - $rectx0) * $from);
                        $y0 = $recty0;
                        $x1 = int($rectx0 + ($rectx1 - $rectx0) * $to);
                        $y1 = $recty1;
#print STDERR ">rect $x0, $y0, $x1, $y1, $color, $comment [$from,$to]\n";
                        $refDomColor->{"$dom"}->{'COLOR'} = $color;
                        $refDomColor->{"$dom"}->{'X0'}    = $x0;
                        $refDomColor->{"$dom"}->{'X1'}    = $x1;
#                        $refDomColor->{"$dom"}->{'Y0'} = $y0;
#                        $refDomColor->{"$dom"}->{'Y1'} = $y1;
                    }
                }
                elsif ($drawCmd =~ /^rect.*\s${gene}.*$/) {
                    ($dmy,$rectx0,$recty0,$rectx1,$recty1,$rectcolor,$comment) = split(/\s+/,$drawCmd);
                    if ($rectx1 < $rectx0) {
                        # $rectx0 < $rectx1 Ȥʤ褦
                        my$wk = $rectx0;
                        $rectx0 = $rectx1;
                        $rectx1 = $wk;
                    }

                    # exon ΰ [] 
                    my($fillx) = int(($rectx0 + $rectx1) / 2);
                    my($filly) = int(($recty0 + $recty1) / 2);
                    $drawCmdNew = sprintf("rect %d %d %s %s %s %s", $rectx0, $recty0, $rectx1, $recty1, $rectcolor, $comment);
                    push(@domLine, $drawCmdNew);
                    $drawCmdNew = sprintf("fill %d %d %s %s", $fillx, $filly, '180_255_255', $comment);
                    push(@domLine, $drawCmdNew);

                    my(@domList) = sort {$a <=> $b} keys(%{$refDomColor});
                    foreach my$dom (@domList) {
                        my($ref) = $refDomColor->{"$dom"};
                        if ((($ref->{'X0'} <= $rectx0) && ($rectx0 <= $ref->{'X1'})) &&
                            (($ref->{'X0'} <= $rectx1) && ($rectx1 <= $ref->{'X1'}))) {
                            #  exon ϡΥɥᥤ

                            #
                            $drawCmdNew = sprintf("rect %d %d %s %s %s %s", $rectx0, $recty0, $rectx1, $recty1, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            #
                            my($fillx) = int(($rectx0 + $rectx1) / 2);
                            my($filly) = int(($recty0 + $recty1) / 2);
                            $drawCmdNew = sprintf("fill %d %d %s %s", $fillx, $filly, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            # Gene Ȥ

                            push(@domLine, $drawCmd);

                            last;
                        }
                        elsif (($rectx0 < $ref->{'X0'}) && ($ref->{'X1'} < $rectx1)) {
                            #  exon ϡΥɥᥤ礭

                            #
                            $drawCmdNew = sprintf("rect %d %d %s %s %s %s", $ref->{'X0'}, $recty0, $ref->{'X1'}, $recty1, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            #
                            my($fillx) = int(($ref->{'X0'} + $ref->{'X1'}) / 2);
                            my($filly) = int(($recty0 + $recty1) / 2);
                            $drawCmdNew = sprintf("fill %d %d %s %s", $fillx, $filly, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            # Gene Ȥ
                            push(@domLine, $drawCmd);
                        }
                        elsif ((($ref->{'X0'} <= $rectx0) && ($rectx0 <= $ref->{'X1'})) && ($ref->{'X1'} < $rectx1)) {
                            #  exon ȾϡΥɥᥤʸȾ̥ɥᥤ

                            #
                            $drawCmdNew = sprintf("rect %d %d %s %s %s %s", $rectx0, $recty0, $ref->{'X1'}, $recty1, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            #
                            my($fillx) = int(($rectx0 + $ref->{'X1'}) / 2);
                            my($filly) = int(($recty0 + $recty1) / 2);
                            $drawCmdNew = sprintf("fill %d %d %s %s", $fillx, $filly, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            # Gene Ȥ
                            push(@domLine, $drawCmd);
                        }
                        elsif (($rectx0 < $ref->{'X0'}) && (($ref->{'X0'} <= $rectx1) && ($rectx1 <= $ref->{'X1'}))) {
                            #  exon θȾϡΥɥᥤȾ̥ɥᥤ

                            #
                            $drawCmdNew = sprintf("rect %d %d %s %s %s %s", $ref->{'X0'}, $recty0, $rectx1, $recty1, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            #
                            my($fillx) = int(($ref->{'X0'} + $rectx1) / 2);
                            my($filly) = int(($recty0 + $recty1) / 2);
                            $drawCmdNew = sprintf("fill %d %d %s %s", $fillx, $filly, $ref->{'COLOR'}, $comment);
                            push(@domLine, $drawCmdNew);

                            # Gene Ȥ
                            push(@domLine, $drawCmd);
                        }
                        else {
                            #  exon ϡ̥ɥᥤ

                            # Gene Ȥ
                            push(@domLine, $drawCmd);
                        }
                    }
                }
                elsif ($drawCmd =~ /^fill\s+(\d+)\s+(\d+)\s+(\S+)\s+(${gene})\b/i) {
                    # exon ñ̤Ǥ rect  fill ѤߤǤ
                    # ʳ fill ʤ
                }
                else {
                    push(@domLine, $drawCmd);
                    next;
                }
            }
            @commands = @domLine;
        }
    }
    unshift( @commands, $first_line );
    
#    for $x (@commands){
#        print STDERR "AA>$x\n";
#    }
}

#
local( $first_line, $new_color, $old_color );
$old_color  = $MBGD_REGION_IMG_GENE_COLOR;
$new_color  = $MBGD_REGION_IMG_GENE_COLOR_LINK;
$first_line = shift( @commands );
unshift( @commands, "color $old_color\n" );
unshift( @commands, "color $new_color\n" );
unshift( @commands, $first_line );
local( $list, *RES, $str, $end );
$str = $RegCenter - int( $RegWidth / 2 );
$end = $RegWidth + $str;

$image = &MBGDImg_Draw( @commands );

print "Content-type: image/gif\n\n" unless($TEST);
print $image->gif;

exit;

###############################################################################
# ꤷޥɤꤷꥹȤˤĤƼ¹Ԥ
# input : ԽޥɥƥȡԽꥹ
# return: Խꥹ
sub sed_list
{
    local( $cmnd, @list ) = @_;
    local( $line );
    local( @result );

    while( scalar( @list )) {
        $_ = shift( @list );
        eval "$cmnd";
        push( @result, $_ );
    }

    @result;
}

###############################################################################
