#!/usr/bin/perl -s

################################################################################

use GD;
use MBGD;
use MBGD::WWW;
use MBGD::WWW::SeqRegMap;
require "MBGD_common.pl";
require "libMBGDImgMap.pl";
require "libMBGDaxes.pl";
require "emergency.pl";

# MBGD::WWW::SeqRegMap ǻѤƤѿ RECOG Ѥѹ
$MBGD::WWW::SeqRegMap::MODE = 'RECOG';
$MBGD::WWW::SeqRegMap::DomURL = "javascript:;//"; # åƤⲿ⤷ʤ
$MBGD::WWW::SeqRegMap::MotURL = "searchGeneByMotif.pl";
$MBGD::WWW::SeqRegMap::SimURL = "align";
$MBGD::WWW::SeqRegMap::GeneURL = "RECOG_gene_info_frame.pl";

# Хѿ
$Path_htbin = "$MBGD_PATH_HTBIN";

#
$WWW = MBGD::WWW->new;
$db = MBGD::DB->new($ENV{'MYSQL_DB'});

print "Content-Type:text/plain\n\n" if( $TEST );

my $cgi = $WWW->cgi;

$GeneName  = $cgi->param('name');   # Gene to be centered in the region
$displayMode  = $cgi->param('displayMode');
$display  = $cgi->param('display');

if (! $GeneName) {
	print "Content-Type:text/html\n\n";
	print "gene name is not specified\n";
	exit;
}

$gene = MBGD::Gene->get($GeneName);
$seqlen = $gene->length;

#$uInfo = $WWW->uInfo;
#$tabIDs = $uInfo->loadTableIDs;
#$tabid = $tabIDs->{current};
$tabid  = $cgi->param('tabid');

#### print HTML
print "Content-Type:text/html\n\n";

print <<"EOD";
<HTML>
<HEAD> <TITLE> Sequence Domain Map </TITLE> </HEAD>
<BODY bgcolor="#f0fff0">
EOD

if ($displayMode eq 'Homology') {
	print "<H2>Homology Search Results</H2>\n";
}
print "<b>[Graphic Display]</b>";
if ($displayMode eq 'Homology') {
	print "<A HREF=\"SeqSearch.pl?orfname=$GeneName&tabid=$tabid\">[Text Display]</A><br>\n";
} elsif ($displayMode eq 'Motif') {
	print "<A HREF=\"searchMotifByGene.pl?name=$GeneName&tabid=$tabid\">[Text Display]</A><br>\n";
}

#$seqregMap = MBGD::WWW::SeqRegMap->new($GeneName, tabid=>$tabid, uInfo=>$uInfo);
$seqregMap = MBGD::WWW::SeqRegMap->new($GeneName, tabid=>$tabid);
if ($displayMode eq 'Homology') {
	$seqregMap->drawAllHomology(mode=>'clmap');
} elsif ($displayMode eq 'Motif') {
	$seqregMap->drawAllMotif(mode=>'clmap');
} elsif ($display) {
	$seqregMap->drawAll($display, mode=>'clmap');
}
$displayOpt = $displayMode ? "displayMode=$displayMode" : "display=$display";

$ImageMap = $seqregMap->make_clmap;
print <<"EOD";
<MAP NAME="SEQ_MAP">
$ImageMap
</MAP>

<IMG SRC="RECOG_seqreg_image.pl?name=$GeneName&$displayOpt&tabid=$tabid" USEMAP="#SEQ_MAP" BORDER=0>
</BODY> </HTML>
EOD

exit;

###############################################################################
