#!/usr/bin/perl -s
use CGI qw/ :standard start_table end_table /;
use RECOG;
use RECOG::DomClustCommon;
use RECOG::MBGD::DomClust;
use RECOG::MBGD::ClusterTable;
use RECOG::MBGD::OutputDomClust;
use MBGD::DB;
use MBGD::Taxonomy;

###############################################################################
#
sub delete_cluster {
    my($clustid) = shift;

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);
    deleteCacheTable($db, $clustid);

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "</head>\n";
    print "\n";
    print "<body>\n";
    print "\n";
    print "<a href=\"/htbin/RECOG/list_cluster.cgi\">List cluster(s).</a>\n";
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($clustid) = $cgi->param('clust_id');

    delete_cluster($clustid);
}

###############################################################################
1;#
###############################################################################
