#!/usr/bin/perl -s
use strict;
use MBGD::DB;
use CGI;
use MBGD::DB;
use MBGD::Taxonomy;
use MBGD::Genome;
require 'MBGD_Conf.pl';

###############################################################################
#
sub print_select_species {
    my($db) = shift;
    my($key_name) = shift;
    my($key_value) = shift;

    #
    my(@selected_spec_list) = split(/,/, $key_value);
    my(%selected_spec_hash);
    foreach my$spec (@selected_spec_list) {
        $selected_spec_hash{"$spec"} = 1;
    }

    #
    my($dbname) = $main::DBNAME_MBGD;
    my($db) = MBGD::DB->new($dbname);

    my($tax) = MBGD::Taxonomy->new();
    my(@spec_list) = $tax->get_all_spec();

    print "<h1>$key_name</h1>\n";
    print qq{<form method="post" action="/htbin/RECOG/edit_attribute.cgi">\n};
    print qq{<input type="hidden" name="key_name" value="$key_name">\n};
    print qq{<select name="key_value" multiple size="20">\n};
    foreach my$spec (@spec_list) {
        my($sta_selected) = '';
        if ($selected_spec_hash{"$spec"}) {
            $sta_selected = 'selected';
        }

        my($ref) = MBGD::Genome->get($db, ["$spec"]);
        print qq{<option value="$spec" $sta_selected>};
        print $ref->{'orgname'};
        if ($ref->{'strain'} ne '') {
            print "(", $ref->{'strain'}, ")";
        }
        print "</option>\n";
    }
    print "</select><br>\n";
    print qq{<input type="submit" name="btn_submit" value="Select">};
    print qq{<input type="reset" value="Reset">};

    print "</form>\n";

    return;
}

###############################################################################
#
sub print_text {
    my($db) = shift;
    my($key_name) = shift;
    my($key_value) = shift;

    #
    my($dbname) = $main::DBNAME_MBGD;
    my($db) = MBGD::DB->new($dbname);

    print "<h1>$key_name</h1>\n";
    print qq{<form method="post" action="/htbin/RECOG/edit_attribute.cgi">\n};
    print qq{<input type="hidden" name="key_name" value="$key_name">\n};
    print qq{<input type="text" name="key_value" value="$key_value"><br>\n};
    print qq{<input type="submit" name="btn_submit" value="Set">};
    print qq{<input type="reset" value="Reset">};

    print "</form>\n";

    return;
}

###############################################################################
#
sub edit_attribute_win {
    my($cgi) = shift;

    my($key_name) = $cgi->param('key_name');

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "</head>\n";

    #
    my($dbname) = $main::DBNAME_MBGD;
    my($db) = MBGD::DB->new($dbname);
    my($tab) = "attribute";

    my($category, $name) = split(/\:/, $key_name);
    my($where) = "category='$category' and name='$name'";
    my($sql) = "select * from $tab where $where";
    my($sth) = $db->execute($sql);
    my($ref) = $sth->fetchrow_hashref();
    my($key_value) = $ref->{'value'};

    #
    if ($key_name =~ /genome:species_metagenome/) {
        print_select_species($db, $key_name, $key_value);
    }
    elsif ($key_name =~ /genome:species_incomplete/) {
        print_select_species($db, $key_name, $key_value);
    }
    else {
        print_text($db, $key_name, $key_value);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();
    edit_attribute_win($cgi);
}

###############################################################################
1;#
###############################################################################
